package jp.hasc.hasctool.core.blockdiagram.test;

import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;
import jp.hasc.hasctool.core.blockdiagram.model.PortReference;
import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.core.runtime.sink.LineWriterSink;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;
import junit.framework.TestCase;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

/**
 * @author iwasaki
 */
public class XStreamTest extends TestCase {
	
	public static final String INPUT_FILE_NAME = "test1.acc.csv";
	public static final String OUTPUT_FILE_NAME = "output.csv";

	public void test1() {
		String s;
		{
			XStream xs=newXStream();
			BlockDiagram bd1=createSampleDiagram();
			s=xs.toXML(bd1);
			System.out.println(s);
		}
		{
			XStream xs=newXStream();
			BlockDiagram bd2=(BlockDiagram)xs.fromXML(s);
			//
			XStream xs2=newXStream();
			String s2 = xs2.toXML(bd2);
			assertEquals(s, s2);
		}
		 
	}
	
	private static XStream newXStream() {
		XStream xs = new XStream(new DomDriver());
		xs.autodetectAnnotations(true);
		xs.aliasPackage("model", BlockDiagram.class.getPackage().getName());
		return xs;
	}
	
	public static BlockDiagram createSampleDiagram() {
		BlockDiagram bd=new BlockDiagram();
		//
		BeanBlock reader=new BeanBlock();
		reader.setName("reader");
		reader.setRuntimeClassName(LineReaderSource.class.getName());
		reader.setProperty("filePath",INPUT_FILE_NAME);
		//si.setViewPosition(new Point(100,200));
		bd.addBlock(reader);
		//
		BeanBlock writer=new BeanBlock();
		writer.setName("writer");
		writer.setRuntimeClassName(LineWriterSink.class.getName());
		writer.setProperty("filePath",OUTPUT_FILE_NAME);
		//so.setViewPosition(new Point(200,100));
		bd.addBlock(writer);
		//
		Connection c1 = new Connection(reader.getPortByName(PortReference.OUTPUT_PORT), writer.getPortByName(PortReference.INPUT_PORT));
		//c1.getViewIntermediatePoints().add(new Point(200,100));
		bd.addConnection(c1);
		//
		return bd;
	}

}
