package jp.hasc.hasctool.core.messaging;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;

/**
 * メッセージを受信してBlockingQueueに積む、MessageProcessorです。別スレッドで、readMessage()を呼んでキューから取り出すことが出来ます
 * @author iwasaki
 */
public class MessageQueue implements MessageProcessor {
	private BlockingQueue<Object> queueImpl_;
	
	public MessageQueue() {
		queueImpl_=new LinkedBlockingQueue<Object>();
	}

	public MessageQueue(int capacity) {
		if (capacity==0) {
			queueImpl_=new SynchronousQueue<Object>();
		}else{
			queueImpl_=new LinkedBlockingQueue<Object>(capacity);
		}
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		queueImpl_.put(message);
	}
	
	public Object readMessage() throws InterruptedException {
		return queueImpl_.take();
	}

	public BlockingQueue<Object> getQueueImpl() {
		return queueImpl_;
	}
}
