package jp.hasc.hasctool.core.runtime.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * 入出力ポートに関するメタデータです
 * @author iwasaki
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({})
public @interface PortInfo {
	/**
	 * ポートの名前です
	 * 配列の場合は、"portName[]" という形式の名前にします。
	 */
	String name();
	
	/**
	 * ポートに入力できる（入力する意味がある）、またはポートから出力されうる、メッセージオブジェクトのクラス（複数可）を記述します。
	 * SignalMessage.BEGIN/END (EnumCommand.BEGIN/END) は記述不要です。
	 */
	Class<? extends Object>[] classes() default {};
}
