package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.messaging.SignalMessageTimeChecker;
import jp.hasc.hasctool.core.runtime.AbstractRuntimeBean;

/**
 * 1入力1出力のフィルタです
 * @author iwasaki
 */
public abstract class AbstractFilter extends AbstractRuntimeBean implements MessageProcessor {
	public MessageProcessor getInputPort() { return this; }
	
	private MessageConnector outputPort_ = new MessageConnector();
	
	public MessageConnector getOutputPort() { return outputPort_; }
	
	private SignalMessageTimeChecker sigChecker_=new SignalMessageTimeChecker();
	
	protected void outputMessage(Object message) throws InterruptedException {
		sigChecker_.checkMessage(message);
		getOutputPort().processMessage(message);
	}
	
	protected MessageProcessor getInputPortToOutputMessage() {
		return new MessageProcessor() {
			@Override
			public void processMessage(Object message) throws InterruptedException {
				outputMessage(message);
			}
		};
	}
}
