package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;

/**
 * VectorSignalMessageの単一要素を出力するフィルタです
 * @author hiro, iwasaki
 */
public class VectorElementFilter extends AbstractFilter {

	private int elementIndex_;

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			VectorSignalMessage vsig = (VectorSignalMessage) message;
			// output
			outputMessage(VectorSignalMessages.createScalar(vsig.getTime(),vsig.getVectorElement(elementIndex_)));
		}else{
			outputMessage(message);
		}
	}

	public int getElementIndex() {
		return elementIndex_;
	}

	public void setElementIndex(int elementIndex) {
		elementIndex_ = elementIndex;
	}
}
