package jp.hasc.hasctool.core.runtime.filter.file.label;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * label毎の計測時間を取得します
 * @author hiro
 */

public class LabelTimeFilter extends AbstractFilter{

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String line =(String)message;
			String[] row = line.split(",");
			if(row.length == 3){
				double time 
				= Double.parseDouble(row[1])-Double.parseDouble(row[0]);
				outputMessage(row[2]+","+time);
			}
		} else {
			//BEGIN message
			outputMessage(message);
		}
	}

}
