package jp.hasc.hasctool.core.runtime.filter.file.table;

import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * 指定した項目を使ったテーブルの編集
 * 指定した情報を含むファイルについてのテーブル作成
 * 複数の情報を指定可（ただし","で区切ること！）
 * @author hiro
 */

public class InformationEffector extends TableEffector{

	boolean start_ = true;
	String inf_;
	String[] infArray_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		infArray_ = inf_.split(",");
	}

	String getResult(String line){
		String row = null;
		if(start_){
			row = line;
			start_ = false;
		} else{
			for(int i=0; i<infArray_.length; i++){
				if (0 <= line.indexOf(infArray_[i])){
					row = line;
					break;
				}
			}
		}
		return row;
	}

	public void setInformation(String inf){
		inf_ = inf;
	}

}
