package jp.hasc.hasctool.core.runtime.filter.file.table;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * テーブル編集クラス（abstract class）
 * @author hiro
 */

public abstract class TableEffector extends AbstractFilter{

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String inf = getResult(s);
			if(inf != null){
				outputMessage(inf);
			}
		}else {
			//BEGIN or END message
			outputMessage(message);
		}
	}

	abstract String getResult(String filePath);

}
