package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.ComplexVectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.data.Complex;

/**
 * startF_からendF_の周波数帯をカットします
 * @author hiro
 */

public class CutOffFrequencyFilter extends AbstractFilter {

	private int startF_;
	private int endF_;

	public void setStartFrequency(int sf) {
		startF_= sf;
	}
	
	public void setEndFrequency(int ef) {
		endF_= ef;
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof ComplexVectorSignalMessage) {
			// ComplexVectorSignalMessageの場合
			VectorSignalMessage cvsig=(VectorSignalMessage)message;
			// 新しいベクトルの値を計算
			int len = cvsig.getVectorSize();
			Complex[] newValue = new Complex[len];
			for(int i=0; i<len; i++){
				int j = i+1;
				if(j >= startF_ && j <= endF_){
					newValue[i] = new Complex(0, 0);
				}else if((len+1-endF_) <= j && j <= (len+1-startF_)){
					newValue[i] = new Complex(0, 0);
				}else{
					newValue[i] = ((ComplexVectorSignalMessage)cvsig).getVectorValue(i);
				}
			}
			// 結果を出力
			outputMessage(new ComplexVectorSignalMessage(cvsig.getTime(), newValue, true));
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}
}
