package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.Complex;
import jp.hasc.hasctool.core.data.ComplexVectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * フーリエ変換を行うフィルタです
 * @author hiro
 */

public class FFTFilter extends AbstractFilter {

	private FFT fft;//FFT

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			//VectorSignalMessageの場合
			VectorSignalMessage vsig=(VectorSignalMessage)message;
			// 新しいベクトルの値を計算
			Complex[] data = new Complex[vsig.getVectorSize()];
		    for(int i=0;i<data.length;i++){
		    	data[i]= new Complex(vsig.getVectorElement(i), 0.0);
		    }
			fft = new FFT(false);
			fft.setdata(data);
			fft.execute();
			Complex[] newValue = fft.getdata();
			// 結果を出力
			outputMessage(new ComplexVectorSignalMessage(vsig.getTime(), newValue, true));
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}
}
