package jp.hasc.hasctool.core.runtime.filter.meta;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.util.CoreUtil;

/**
 * メタ要素(metaElement)の内容が指定されたメタ情報(metaInformation)と一致する
 * ファイル名のみ出力します
 * @author hiro
 */
public class MetaInformationFilter extends AbstractFilter{

	private String metaElement_;
	private String metaInformation_;
	private boolean not_=false;

	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String filePath =(String)message;
			try{
				InputStream inps = getRuntimeContext().getFileStreamProvider().openInputStream(filePath);
				BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));
				while(true){
					String line = bufferedReader.readLine();
					if (line == null) {
						break;
					} else if ((0 <= line.indexOf(metaElement_)) && (0 <= line.indexOf(metaInformation_))){
						if (!not_)outputMessage(message);
						break;
					} else if ((0 <= line.indexOf(metaElement_))){
						if (not_)outputMessage(message);
						break;
					}
				}
				bufferedReader.close();
				inps.close();
			} catch (IOException ex) {
				CoreUtil.throwAsRuntimeException(ex);
			} catch (RuntimeException ex) {
			}
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}


	public void setMetaElement(String metaEle) {
		metaElement_ = metaEle;
	}

	public void setMetaInformation(String metaInf) {
		metaInformation_ = metaInf;
	}

	/**
	 * trueなら条件に合わないものを出力します。
	 */
	public void setNot(boolean not) {
		not_ = not;
	}

}
