package jp.hasc.hasctool.core.runtime.filter.tick;

import jp.hasc.hasctool.core.data.NullSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.messaging.MessageProcessor;

/**
 * たまにしかSignalMessageを出力しないフィルタを作る場合に、定期的にNullSignalMessageを出力することによって、
 * 後続のブロックの時刻を進めるためのアルゴリズムです。
 * 
 * @author iwasaki
 */
public abstract class TickEmitter {

	private MessageProcessor inputPortToOutputMessage_;

	public MessageProcessor getInputPortToOutputMessage() {
		return inputPortToOutputMessage_;
	}

	public void setInputPortToOutputMessage(MessageProcessor outputPort) {
		inputPortToOutputMessage_ = outputPort;
	}
	
	protected void outputTickMessage(long time) throws InterruptedException {
		getInputPortToOutputMessage().processMessage(new NullSignalMessage(time));
	}

	public abstract void afterProcessSignalMessage(SignalMessage sig) throws InterruptedException;
	
	public abstract void onOutputSignalMessage(SignalMessage sig);
}
