package jp.hasc.hasctool.core.runtime.filter.window;

/**
 * AbstractFilterを使ったフィルタ
 * ベクトルの各要素に対してHamming窓を適用する
 * @author hiro
 */
public class HammingWindowFunctionFilter extends AbstractWindowFunctionFilter {

	public double[] windowFunction(double[] input, int index){
		int N = input.length;
		double[] newValue = new double[N];
		for(int n=0; n<N; n++){
			int m = (n+index)%N;
			double val = 0.54 - 0.46*Math.cos( 2.0 * Math.PI * n/(N-1) );
			newValue[n] = input[m] * val;
		}
		
		return newValue;
	}
	
}
