package jp.hasc.hasctool.core.runtime.hierarchize;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.messaging.MessageQueue;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * inputPortから入力された、XbdExecutionRequestの系列に基づいて、順にXbdファイルをバッチ実行していくブロックです。
 * inputPortのプロトコル；
 * 　まずEnumCommand.BEGINを渡し、続いてXbdExecutionRequestオブジェクトを複数回渡し、最後にEnumCommand.ENDを渡して下さい。
 * @author iwasaki
 */
public class XbdExecutor extends AbstractTask {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(XbdExecutor.class);
	
	private MessageQueue inputQueue_;
	private String defaultXbdFilePath_ = null;
	
	public MessageProcessor getInputPort() { return inputQueue_; }
	
	private boolean shutdown_=false;
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		inputQueue_ = context.createDefaultMessageQueue();
	}
	
	@Override
	protected void run() throws InterruptedException {
		RuntimeContext outerContext = getRuntimeContext();
		/*
		Runnable stopTasksListener=new Runnable() {
			@Override
			public void run() {
				shutdown_=true;
			}
		};
		*/
		//getRuntimeContext().addStopTasksListener(stopTasksListener);
		//
		try{
			while(!shutdown_) {
				Object message = inputQueue_.readMessage();
				if (message instanceof XbdExecutionRequest) {
					XbdExecutionRequest req=(XbdExecutionRequest)message;
					//
					if (req.getXbdFilePath()==null) req.setXbdFilePath(defaultXbdFilePath_);
					if (req.getXbdFilePath()==null) throw new NullPointerException("xbdFilePath==null");
					LOG.debug("execute "+req.getXbdFilePath());
					//
					InnerXbdExecutor innerXbdExecutor=new InnerXbdExecutor();
					innerXbdExecutor.load(outerContext, req);
					innerXbdExecutor.start();
					innerXbdExecutor.awaitTasksTermination();
					//innerXbdExecutor.dispose();
					
				}else if (message==EnumCommand.END) {
					shutdown_=true;
				}
			}
		}finally{
			//getRuntimeContext().removeStopTasksListener(stopTasksListener);
		}
	}
	
	/**
	 * 入力されたXbdExecutionRequestに、xbdFilePathが指定されていなかった時に、使用するxbdFilePathを指定します
	 */
	public void setDefaultXbdFilePath(String defaultXbdFilePath) {
		defaultXbdFilePath_ = defaultXbdFilePath;
	}

}
