package jp.hasc.hasctool.core.runtime.source;

import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.runtime.AbstractTask;

/**
 * Sourceのbaseとなるclass
 * @author iwasaki
 */
public abstract class AbstractSource extends AbstractTask {
	private MessageConnector outputPort_ = new MessageConnector();
	
	public MessageConnector getOutputPort() { return outputPort_; }
	
	protected void outputMessage(Object message) throws InterruptedException {
		getOutputPort().processMessage(message);
	}
}
