package jp.hasc.hasctool.ui.views;

import jp.hasc.hasctool.core.blockdiagram.BlockDiagramExecutor;
import jp.hasc.hasctool.core.runtime.AbstractRuntimeBean;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.util.CoreUtil;

import org.eclipse.ui.IWorkbenchWindow;

/**
 * 
 * @author hodaka
 *
 */
public abstract class AbstractRuntimeCoordinateView extends AbstractRuntimeBean {

	private String name_ = null;
	private String imgPath_ = "";
	private double imgSize_ = 1;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		try {
			String fname=(String) context.getObjectFromRepogitory(BlockDiagramExecutor.KEY_BLOCK_DIAGRAM_FILE_NAME);
			if (fname==null) fname="";
			IWorkbenchWindow window=(IWorkbenchWindow) context.getObjectFromRepogitory(IWorkbenchWindow.class);
			setupView(window, fname + (name_!=null ? (" - "+name_) : ""));
		} catch (Exception ex) {
			CoreUtil.throwAsRuntimeException(ex);
		}
	}
	
	protected abstract void setupView(IWorkbenchWindow window, String keyName) throws Exception;

	public String getName() {
		return name_;
	}

	public void setName(String name) {
		name_ = name;
	}

	public String getImgPath() {
		return imgPath_;
	}

	public void setImgPath(String imgPath) {
		imgPath_ = imgPath;
	}

}
