package jp.hasc.hasctool.ui.views;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.DelayFilter;
import jp.hasc.hasctool.core.runtime.filter.MeanFilter;
import jp.hasc.hasctool.core.runtime.filter.SampleFilter1;
import jp.hasc.hasctool.core.runtime.filter.ScalarAdder;
import jp.hasc.hasctool.core.runtime.filter.ScalarMultiplier;
import jp.hasc.hasctool.core.runtime.filter.SignalTimeSorter;
import jp.hasc.hasctool.core.runtime.filter.SleepFilter;
import jp.hasc.hasctool.core.runtime.filter.VarianceFilter;
import jp.hasc.hasctool.core.runtime.filter.VectorAdder;
import jp.hasc.hasctool.core.runtime.filter.VectorConcatenater;
import jp.hasc.hasctool.core.runtime.filter.VectorIntegrator;
import jp.hasc.hasctool.core.runtime.filter.VectorElementFilter;
import jp.hasc.hasctool.core.runtime.filter.file.CSVToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.file.HascLogAccToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.file.VectorToCSVFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.ComplexToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.FFTFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.HighPassFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.LowPassFilter;
import jp.hasc.hasctool.core.runtime.filter.interpolator.PeriodicSignalSampler;
import jp.hasc.hasctool.core.runtime.filter.interpolator.VectorPeriodicSignalSampler;
import jp.hasc.hasctool.core.runtime.filter.window.AbstractWindowFunctionFilter;
import jp.hasc.hasctool.core.runtime.filter.window.HanningWindowFunctionFilter;
import jp.hasc.hasctool.core.runtime.sink.LineWriterSink;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;
import jp.hasc.hasctool.core.runtime.source.SinWaveGenerator;
import jp.hasc.hasctool.core.runtime.source.UDPStringReceiver;
import jp.hasc.hasctool.core.util.CoreUtil;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

/**
 * ハードコーディングされたruntimeのサンプル（旧PatchView）
 * @author iwasaki, hiro
 */
public class RuntimeSamplesView extends ViewPart {

	public static final String ID = "jp.hasc.hasctool.ui.views.RuntimeSamplesView";
	private static final long TIME_10MS = SignalMessage.TIME_UNIT.convert(10, TimeUnit.MILLISECONDS);
	private static final long TIME_30MS = SignalMessage.TIME_UNIT.convert(30, TimeUnit.MILLISECONDS);
	private static final long TIME_1000MS =SignalMessage.TIME_UNIT.convert(1000, TimeUnit.MILLISECONDS);

	protected WaveView waveView_;
	protected VectorView vectorView_;
	protected RuntimeContext context_ = null;
	protected static int waveViewIndex__=0;
	
	protected SinWaveGenerator createSinWaveGenerator(long cycle, long tickEnd, long tickInterval) {
		SinWaveGenerator sw=new SinWaveGenerator();
		sw.setCycle(cycle);
		sw.setTickEnd(tickEnd);
		sw.setTickInterval(tickInterval);
		sw.setup(context_);
		return sw;
	}
	protected SinWaveGenerator createSampleSinWaveGenerator() {
		return createSinWaveGenerator(
				SignalMessage.TIME_UNIT.convert(1000, TimeUnit.MILLISECONDS), // cycle
				SignalMessage.TIME_UNIT.convert(10*1000, TimeUnit.MILLISECONDS), // tickEnd
				TIME_10MS); // tickInterval
	}
	
	protected SinWaveGenerator createSampleSinWave2Generator() {
		return createSinWaveGenerator(
				SignalMessage.TIME_UNIT.convert(100, TimeUnit.MILLISECONDS), // cycle
				SignalMessage.TIME_UNIT.convert(10*1000, TimeUnit.MILLISECONDS), // tickEnd
				SignalMessage.TIME_UNIT.convert(7, TimeUnit.MILLISECONDS)); // tickInterval
	}
	
	protected SinWaveGenerator createSampleSinWave3Generator() {
		return createSinWaveGenerator(
				SignalMessage.TIME_UNIT.convert(2010, TimeUnit.MILLISECONDS), // cycle
				SignalMessage.TIME_UNIT.convert(10*1000, TimeUnit.MILLISECONDS), // tickEnd
				SignalMessage.TIME_UNIT.convert(77, TimeUnit.MILLISECONDS)); // tickInterval
	}
	
	protected SinWaveGenerator createSampleSinWave4Generator() {
		return createSinWaveGenerator(
				SignalMessage.TIME_UNIT.convert((long)(2*Math.PI*1000000), TimeUnit.MICROSECONDS), // cycle
				SignalMessage.TIME_UNIT.convert(10*1000, TimeUnit.MILLISECONDS), // tickEnd
				SignalMessage.TIME_UNIT.convert(30, TimeUnit.MILLISECONDS)); // tickInterval
	}
	
	protected MessageProcessor getVectorViewSink() {
		if (vectorViewSink_==null) {
			// sink2 VectorView
			MessageConnector sink2 = new MessageConnector();
			vectorViewSink_ = sink2;
			
			// sleepr
			if (!timeScaleText_.getText().isEmpty()) {
				SleepFilter sleeper=new SleepFilter();
				sleeper.setTimeScale(Double.parseDouble(timeScaleText_.getText()));
				sleeper.setup(context_);
					//
					sink2.connect(sleeper.getInputPort());
					sleeper.getOutputPort().connect(getVectorView().getInputPort());
			}else{
					sink2.connect(getVectorView().getInputPort());
			}
		}
		
		return vectorViewSink_;
	}
	
	protected MessageProcessor getWaveViewSink() {
		if (waveViewSink_==null) {
			// sink WaveView
			MessageConnector sink = new MessageConnector();
			waveViewSink_ = sink;
			
			// sleep
			if (!timeScaleText_.getText().isEmpty()) {
				SleepFilter sleeper=new SleepFilter();
				sleeper.setTimeScale(Double.parseDouble(timeScaleText_.getText()));
				sleeper.setup(context_);
				//
				sink.connect(sleeper.getInputPort());
				sleeper.getOutputPort().connect(getWaveView().getInputPort());
			}else{
				sink.connect(getWaveView().getInputPort());
			}
			
			// csv output
			if (csvOutputFileName_!=null) {
				try {
					VectorToCSVFilter csvout=new VectorToCSVFilter();
					csvout.setup(context_);
					LineWriterSink lw=new LineWriterSink();
					lw.setWriter(new FileWriter(csvOutputFileName_));
					
					sink.connect(csvout.getInputPort());
					csvout.getOutputPort().connect(lw.getInputPort());
				} catch (IOException ex) {
					ex.printStackTrace();
				}
			}
		}
		return waveViewSink_;
	}
	
	/**
	 * タスク実行前の初期化
	 */
	protected void initTaskManager() {
		
		waveView_=null;
		waveViewSink_=null;
		vectorView_=null;
		vectorViewSink_=null;
		
		// taskManager
		context_ = new RuntimeContext();
		if (!queueCapacityText_.getText().isEmpty()) {
			context_.setDefaultMessageQueueCapacity(Integer.parseInt(queueCapacityText_.getText()));
		}
		
	}
	
	private MessageProcessor waveViewSink_;
	private MessageProcessor vectorViewSink_;
	protected String csvOutputFileName_=null;
	protected Text csvOutputFileNameText_;
	
	protected VectorView getVectorView() {
		if (vectorView_==null) {
			try {
				// show vectorView
				vectorView_ = (VectorView) getViewSite().getWorkbenchWindow()
						.getActivePage().showView(VectorView.ID
				,null, IWorkbenchPage.VIEW_ACTIVATE); // Integer.toString(waveViewIndex__++)
			} catch (PartInitException ex) {
				ex.printStackTrace();
				CoreUtil.throwAsRuntimeException(ex);
			}
		}
		return vectorView_;
	}
	
	protected WaveView getWaveView() {
		if (waveView_==null) {
			// show waveView
			try {
				waveView_=(WaveView) getViewSite().getWorkbenchWindow().getActivePage().showView(WaveView.ID
				,null, IWorkbenchPage.VIEW_ACTIVATE);
			} catch (PartInitException ex) {
				ex.printStackTrace();
				CoreUtil.throwAsRuntimeException(ex);
			}
		}
		return waveView_;
	}
	
	@Override
	public void createPartControl(final Composite parent) {
		/*
		parent.setLayout(new RowLayout());
		Composite pane1=parent, pane2=parent;
		*/
		
		parent.setLayout(new GridLayout(1,true));
		Composite pane1=new Composite(parent,SWT.NONE);
		pane1.setLayoutData(new GridData(GridData.FILL, GridData.BEGINNING, true, false));
		pane1.setLayout(new RowLayout());
		Composite pane2=new Composite(parent,SWT.NONE);
		pane2.setLayoutData(new GridData(GridData.FILL, GridData.BEGINNING, true, false));
		pane2.setLayout(new RowLayout());
		Composite pane3=new Composite(parent,SWT.NONE);
		pane3.setLayoutData(new GridData(GridData.FILL, GridData.BEGINNING, true, false));
		pane3.setLayout(new RowLayout());
		
		// sin
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("sin(t)");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					
					// connect
					sinGen.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// sin2
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("0.5 * (1 + sin(t))");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					
					ScalarAdder add=new ScalarAdder();
					add.setOffset(1);
					add.setup(context_);
					
					ScalarMultiplier mul=new ScalarMultiplier();
					mul.setScale(0.5);
					mul.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(add.getInputPort());
					add.getOutputPort().connect(mul.getInputPort());
					mul.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// delay, concat
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("sin(t), sin(t - 100ms)");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					DelayFilter delay = new DelayFilter();
					delay.setDelay(SignalMessage.TIME_UNIT.convert(100, TimeUnit.MILLISECONDS));
					delay.setup(context_);
					
					VectorConcatenater concat=new VectorConcatenater();
					concat.setInputPortCount(2);
					concat.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(concat.getInputPort(0));
					sinGen.getOutputPort().connect(delay.getInputPort());
					delay.getOutputPort().connect(concat.getInputPort(1));
					concat.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// vector adder
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("sin(t) - 0.5 * sin(t - 100ms)");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					
					DelayFilter delay = new DelayFilter();
					delay.setDelay(SignalMessage.TIME_UNIT.convert(100, TimeUnit.MILLISECONDS));
					delay.setup(context_);
					
					ScalarMultiplier smul=new ScalarMultiplier();
					smul.setScale(-0.5);
					smul.setup(context_);
					
					VectorAdder vadd=new VectorAdder();
					vadd.setInputPortCount(2);
					vadd.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(vadd.getInputPort(0));
					
					sinGen.getOutputPort().connect(delay.getInputPort());
					delay.getOutputPort().connect(smul.getInputPort());
					smul.getOutputPort().connect(vadd.getInputPort(1));
					
					vadd.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// two generators t2
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("sin(t) + 0.1 * sin(t2)");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					SinWaveGenerator sinGen2 = createSampleSinWave2Generator();
					
					ScalarMultiplier smul=new ScalarMultiplier();
					smul.setScale(0.1);
					smul.setup(context_);
					
					VectorAdder vadd=new VectorAdder();
					vadd.setInputPortCount(2);
					vadd.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(vadd.getInputPort(0));
					sinGen2.getOutputPort().connect(smul.getInputPort());
					smul.getOutputPort().connect(vadd.getInputPort(1));
					vadd.setPrimaryInputPortIndex(0);
					vadd.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}

			});
		}
		
		// two generators t3
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("sin(t3) + sin(t)");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen3 = createSampleSinWave3Generator();
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					
					VectorAdder vadd=new VectorAdder();
					vadd.setInputPortCount(2);
					vadd.setPrimaryInputPortIndex(0);
					vadd.setup(context_);
					
					// connect
					sinGen3.getOutputPort().connect(vadd.getInputPort(0));
					sinGen.getOutputPort().connect(vadd.getInputPort(1));
					vadd.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// SampleFilter1
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("SampleFilter1");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					
					SampleFilter1 filter=new SampleFilter1();
					filter.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(filter.getInputPort());
					filter.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// PeriodicSignalSampler
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("Periodic2");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWave2Generator();
					
					PeriodicSignalSampler filter=new VectorPeriodicSignalSampler();
					filter.setTimeStep(TIME_30MS);
					filter.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(filter.getInputPort());
					filter.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// PeriodicSignalSampler
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("Periodic3");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWave3Generator();
					
					PeriodicSignalSampler filter=new VectorPeriodicSignalSampler();
					filter.setTimeStep(TIME_30MS);
					filter.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(filter.getInputPort());
					filter.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// VectorIntegrator
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("integrate(sin(t))");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWave4Generator();
					
					VectorIntegrator filter=new VectorIntegrator();
					filter.setInitialValue(VectorSignalMessages.createScalar(0, 0));
					filter.setTimeStep(TIME_10MS);
					filter.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(filter.getInputPort());
					filter.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// http://mech.mech.fukui-u.ac.jp/~Kawa-Lab/simulink/simu1.htm の例
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("Linear ODE");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					final long samplingTime=TIME_10MS;
					VectorIntegrator int0=new VectorIntegrator();
					int0.setInitialValue(VectorSignalMessages.createScalar(0, 0));
					int0.setTimeStep(samplingTime);
					int0.setup(context_);
					
					ScalarMultiplier gain0=new ScalarMultiplier();
					gain0.setScale(-3);
					gain0.setup(context_);
					
					VectorIntegrator int1=new VectorIntegrator();
					int1.setInitialValue(VectorSignalMessages.createScalar(0, 0));
					int1.setTimeStep(samplingTime);
					int1.setup(context_);
					
					ScalarMultiplier gain1=new ScalarMultiplier();
					gain1.setScale(-10);
					gain1.setup(context_);
					
					VectorAdder vadd=new VectorAdder();
					vadd.setInputPortCount(3);
					vadd.setPrimaryInputPortIndex(1); // port0は10ms間隔でない
					vadd.setup(context_);
					final MessageProcessor stepInput = vadd.getInputPort(0);
					
					ScalarMultiplier mult10=new ScalarMultiplier();
					mult10.setScale(10);
					mult10.setup(context_);
					
					// step input
					new AbstractTask() {
						@Override
						protected void run() throws InterruptedException {
							stepInput.processMessage(SignalMessage.BEGIN);
							stepInput.processMessage(VectorSignalMessages.createScalar(0, 0));
							stepInput.processMessage(VectorSignalMessages.createScalar(TIME_1000MS -samplingTime, 0));
							stepInput.processMessage(VectorSignalMessages.createScalar(TIME_1000MS , 1));
							stepInput.processMessage(VectorSignalMessages.createScalar(5*TIME_1000MS , 1));
							stepInput.processMessage(SignalMessage.END);
						}
					}.setup(context_);
					
					// connect
					gain0.getOutputPort().connect(vadd.getInputPort(1));
					gain1.getOutputPort().connect(vadd.getInputPort(2));
					vadd.getOutputPort().connect(int0.getInputPort());
					int0.getOutputPort().connect(int1.getInputPort());
					int0.getOutputPort().connect(gain0.getInputPort());
					int1.getOutputPort().connect(mult10.getInputPort());
					int1.getOutputPort().connect(gain1);
					mult10.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
	
		// HanningWindowFunctionFilter
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("Hanning");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					AbstractWindowFunctionFilter wffilter=new HanningWindowFunctionFilter();
					wffilter.setSampleNum(256);
					wffilter.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(wffilter.getInputPort());
					wffilter.getOutputPort().connect(getVectorViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		
		// FFTFilter
		{
			final Button b = new Button(pane1, SWT.BORDER);
			b.setText("FFTFilter");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					initTaskManager();
					
					// create
					SinWaveGenerator sinGen = createSampleSinWaveGenerator();
					
					AbstractWindowFunctionFilter wffilter = new HanningWindowFunctionFilter();
					wffilter.setSampleNum(256);
					wffilter.setup(context_);
					
					FFTFilter fftfilter = new FFTFilter();
					fftfilter.setup(context_);
					
					ComplexToVectorFilter cvfilter = new ComplexToVectorFilter();
					cvfilter.setup(context_);
					
					// connect
					sinGen.getOutputPort().connect(wffilter.getInputPort());
					wffilter.getOutputPort().connect(fftfilter.getInputPort());
					fftfilter.getOutputPort().connect(cvfilter.getInputPort());
					cvfilter.getOutputPort().connect(getVectorViewSink()); 
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// csv file source
		{
				final FileDialog fileDialog=new FileDialog(parent.getShell(), SWT.OPEN);
				fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc","*"});
				//
				final Button b = new Button(pane2, SWT.BORDER);
				b.setText("CSV file source");
				b.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						String fname=fileDialog.open();
						if (fname!=null) {
							//
							stopTasks();
							initTaskManager();
							
							try {
								// create
								LineReaderSource reader=new LineReaderSource();
								reader.setReader(new FileReader(fname));
								reader.setup(context_);
								
								CSVToVectorFilter parser = new CSVToVectorFilter();
								parser.setup(context_);
							
								// connect
								reader.getOutputPort().connect(parser.getInputPort());
								parser.getOutputPort().connect(getWaveViewSink());
								
								// start
								context_.startTasks();
								
							} catch (FileNotFoundException ex) {
								ex.printStackTrace();
							}
						}
					}
				});
			} 
	
		// csv file mean
		{
				final FileDialog fileDialog=new FileDialog(parent.getShell(), SWT.OPEN);
				fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc","*"});
				//
				final Button b = new Button(pane2, SWT.BORDER);
				b.setText("CSV file mean");
				b.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						String fname=fileDialog.open();
						if (fname!=null) {
							//
							stopTasks();
							initTaskManager();
							
							try {
								// create
								LineReaderSource reader=new LineReaderSource();
								reader.setReader(new FileReader(fname));
								reader.setup(context_);
								
								CSVToVectorFilter parser = new CSVToVectorFilter();
								parser.setup(context_);
								
								MeanFilter mean = new MeanFilter();
								mean.setSampleNum(10);
							
								// connect
								reader.getOutputPort().connect(parser.getInputPort());
								parser.getOutputPort().connect(mean.getInputPort());
								mean.getOutputPort().connect(getWaveViewSink());
								
								// start
								context_.startTasks();
								
							} catch (FileNotFoundException ex) {
								ex.printStackTrace();
							}
						}
					}
				});
			}

		

		// csv file variance
		{
				final FileDialog fileDialog=new FileDialog(parent.getShell(), SWT.OPEN);
				fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc","*"});
				//
				final Button b = new Button(pane2, SWT.BORDER);
				b.setText("CSV file variance");
				b.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						String fname=fileDialog.open();
						if (fname!=null) {
							//
							stopTasks();
							initTaskManager();
							
							try {
								// create
								LineReaderSource reader=new LineReaderSource();
								reader.setReader(new FileReader(fname));
								reader.setup(context_);
								
								CSVToVectorFilter parser = new CSVToVectorFilter();
								parser.setup(context_);
								
								VarianceFilter variance = new VarianceFilter();
								variance.setSampleNum(10);
							
								// connect
								reader.getOutputPort().connect(parser.getInputPort());
								parser.getOutputPort().connect(variance.getInputPort());
								variance.getOutputPort().connect(getWaveViewSink());
								
								// start
								context_.startTasks();
								
							} catch (FileNotFoundException ex) {
								ex.printStackTrace();
							}
						}
					}
				});
			}

	 
		
		// csv file FFT
		{
				final FileDialog fileDialog=new FileDialog(parent.getShell(), SWT.OPEN);
				fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc","*"});
				//
				final Button b = new Button(pane2, SWT.BORDER);
				b.setText("CSV file FFT");
				b.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						String fname=fileDialog.open();
						if (fname!=null) {
							//
							stopTasks();
							initTaskManager();
							
							try {
							
								// create
								LineReaderSource reader=new LineReaderSource();
								reader.setReader(new FileReader(fname));
								reader.setup(context_);
								
								CSVToVectorFilter parser = new CSVToVectorFilter();
								parser.setup(context_);
								
								VectorElementFilter vsfilter = new VectorElementFilter();
								vsfilter.setElementIndex(2);
								vsfilter.setup(context_);
								
								AbstractWindowFunctionFilter wffilter = new HanningWindowFunctionFilter();
								wffilter.setSampleNum(256);
								wffilter.setup(context_);
								
								FFTFilter fftfilter=new FFTFilter();
								fftfilter.setup(context_);
								
								ComplexToVectorFilter cvfilter = new ComplexToVectorFilter();
								cvfilter.setup(context_);
								
								// connect
								reader.getOutputPort().connect(parser.getInputPort());
								parser.getOutputPort().connect(vsfilter.getInputPort());
								vsfilter.getOutputPort().connect(wffilter.getInputPort());
								wffilter.getOutputPort().connect(fftfilter.getInputPort());
								fftfilter.getOutputPort().connect(cvfilter.getInputPort());
								cvfilter.getOutputPort().connect(getVectorViewSink()); 
								
								// start
								context_.startTasks();
								
							} catch (FileNotFoundException ex) {
								ex.printStackTrace();
							}
						}
					}
				});
			}
	
		
		// csv file LowPass
		{
			final FileDialog fileDialog=new FileDialog(parent.getShell(), SWT.OPEN);
			fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc","*"});
			//
			final Button b = new Button(pane2, SWT.BORDER);
			b.setText("CSV file LowPass");
			b.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					String fname=fileDialog.open();
					if (fname!=null) {
						//
						stopTasks();
						initTaskManager();
						
						try {
							// create
								LineReaderSource reader=new LineReaderSource();
								reader.setReader(new FileReader(fname));
								reader.setup(context_);
								
								CSVToVectorFilter parser = new CSVToVectorFilter();
								parser.setup(context_);
								
								VectorElementFilter vsfilter = new VectorElementFilter();
								vsfilter.setElementIndex(2);
								vsfilter.setup(context_);
							
								LowPassFilter lowpassfilter=new LowPassFilter();
								lowpassfilter.setSampleNum(256);
								lowpassfilter.setCutoffFrequency(2);
								lowpassfilter.setup(context_);
								
								// connect
								reader.getOutputPort().connect(parser.getInputPort());
								parser.getOutputPort().connect(vsfilter.getInputPort());
								vsfilter.getOutputPort().connect(lowpassfilter.getInputPort());
								lowpassfilter.getOutputPort().connect(getWaveViewSink());
								
								// start
								context_.startTasks();
							
							
						} catch (FileNotFoundException ex) {
							ex.printStackTrace();
						}
					}
				}
			});
		}
		
		
		// csv file HighPass
		{
			final FileDialog fileDialog=new FileDialog(parent.getShell(), SWT.OPEN);
			fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc","*"});
			//
			final Button b = new Button(pane2, SWT.BORDER);
			b.setText("CSV file HighPass");
			b.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					String fname=fileDialog.open();
					if (fname!=null) {
						//
						stopTasks();
						initTaskManager();
						
						try {
							// create
							LineReaderSource reader=new LineReaderSource();
							reader.setReader(new FileReader(fname));
							reader.setup(context_);
							
							CSVToVectorFilter parser = new CSVToVectorFilter();
							parser.setup(context_);
							
							VectorElementFilter vsfilter = new VectorElementFilter();
							vsfilter.setElementIndex(2);
							vsfilter.setup(context_);
						
							HighPassFilter highpassfilter=new HighPassFilter();
							highpassfilter.setSampleNum(256);
							highpassfilter.setCutoffFrequency(2);
							highpassfilter.setup(context_);
							
							// connect
							reader.getOutputPort().connect(parser.getInputPort());
							parser.getOutputPort().connect(vsfilter.getInputPort());
							vsfilter.getOutputPort().connect(highpassfilter.getInputPort());
							highpassfilter.getOutputPort().connect(getWaveViewSink());
						
							// start
							context_.startTasks();
							
						} catch (FileNotFoundException ex) {
							ex.printStackTrace();
						}
					}
				}
			});
		}
		
		// Hasc log file source
		{
			final FileDialog fileDialog=new FileDialog(parent.getShell(), SWT.OPEN);
			fileDialog.setFilterExtensions(new String[]{"*.log","*"});
			//
			final Button b = new Button(pane2, SWT.BORDER);
			b.setText("Hasc log source");
			b.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					String fname=fileDialog.open();
					if (fname!=null) {
						//
						stopTasks();
						initTaskManager();
						
						try {
							// create
							LineReaderSource reader=new LineReaderSource();
							reader.setReader(new FileReader(fname));
							reader.setup(context_);
							
							HascLogAccToVectorFilter parser = new HascLogAccToVectorFilter();
							parser.setup(context_);
						
							// connect
							reader.getOutputPort().connect(parser.getInputPort());
							parser.getOutputPort().connect(getWaveViewSink());
							
							// start
							context_.startTasks();
							
						} catch (FileNotFoundException ex) {
							ex.printStackTrace();
						}
					}
				}
			});
		}
		
		
		// CSV UDP source
		{
			final Button b = new Button(pane2, SWT.BORDER);
			b.setText("CSV UDP source");
			b.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					timeScaleText_.setText(""); // 遅延無しに
					initTaskManager();
					
					// create
					UDPStringReceiver receiver=new UDPStringReceiver();
					receiver.setup(context_);
					
					CSVToVectorFilter parser = new CSVToVectorFilter();
					parser.setup(context_);
					
					SignalTimeSorter soreter = new SignalTimeSorter();
					soreter.setup(context_);
					
					// connect
					receiver.getOutputPort().connect(parser.getInputPort());
					parser.getOutputPort().connect(soreter.getInputPort());
					soreter.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		
		// CSV UDP FFT
		{
			final Button b = new Button(pane2, SWT.BORDER);
			b.setText("CSV UDP FFT");
			b.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					timeScaleText_.setText(""); // 遅延無しに
					initTaskManager();
					
					// create
					UDPStringReceiver receiver=new UDPStringReceiver();
					receiver.setup(context_);
					
					CSVToVectorFilter parser = new CSVToVectorFilter();
					parser.setup(context_);
					
					SignalTimeSorter soreter = new SignalTimeSorter();
					soreter.setup(context_);
					
					VectorElementFilter vsfilter = new VectorElementFilter();
					vsfilter.setElementIndex(2);
					vsfilter.setup(context_);
					
					AbstractWindowFunctionFilter wffilter = new HanningWindowFunctionFilter();
					wffilter.setSampleNum(256);
					wffilter.setup(context_);
					
					FFTFilter fftfilter=new FFTFilter();
					fftfilter.setup(context_);
					
					ComplexToVectorFilter cvfilter = new ComplexToVectorFilter();
					cvfilter.setup(context_);
					
					// connect
					receiver.getOutputPort().connect(parser.getInputPort());
					parser.getOutputPort().connect(soreter.getInputPort());
					soreter.getOutputPort().connect(vsfilter.getInputPort());
					vsfilter.getOutputPort().connect(wffilter.getInputPort());
					wffilter.getOutputPort().connect(fftfilter.getInputPort());
					fftfilter.getOutputPort().connect(cvfilter.getInputPort());
					cvfilter.getOutputPort().connect(getVectorViewSink()); 
					
					// start
					context_.startTasks();
				}
			});
		}
		
		
		// CSV UDP LowPass
		{
			final Button b = new Button(pane2, SWT.BORDER);
			b.setText("CSV UDP LowPass");
			b.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					timeScaleText_.setText(""); // 遅延無しに
					initTaskManager();
					
					// create
					UDPStringReceiver receiver=new UDPStringReceiver();
					receiver.setup(context_);
					
					CSVToVectorFilter parser = new CSVToVectorFilter();
					parser.setup(context_);
					
					SignalTimeSorter soreter = new SignalTimeSorter();
					soreter.setup(context_);
					
					VectorElementFilter vsfilter = new VectorElementFilter();
					vsfilter.setElementIndex(2);
					vsfilter.setup(context_);
				
					LowPassFilter lowpassfilter=new LowPassFilter();
					lowpassfilter.setSampleNum(256);
					lowpassfilter.setCutoffFrequency(2);
					lowpassfilter.setup(context_);
					
					// connect
					receiver.getOutputPort().connect(parser.getInputPort());
					parser.getOutputPort().connect(soreter.getInputPort());
					soreter.getOutputPort().connect(vsfilter.getInputPort());
					vsfilter.getOutputPort().connect(lowpassfilter.getInputPort());
					lowpassfilter.getOutputPort().connect(getWaveViewSink());
					
					// start
					context_.startTasks();
				}
			});
		}
		
		
		// CSV UDP HighPass
		{
			final Button b = new Button(pane2, SWT.BORDER);
			b.setText("CSV UDP HighPass");
			b.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
					timeScaleText_.setText(""); // 遅延無しに
					initTaskManager();
					
					// create
					UDPStringReceiver receiver=new UDPStringReceiver();
					receiver.setup(context_);
					
					CSVToVectorFilter parser = new CSVToVectorFilter();
					parser.setup(context_);
					
					SignalTimeSorter soreter = new SignalTimeSorter();
					soreter.setup(context_);
					
					VectorElementFilter vsfilter = new VectorElementFilter();
					vsfilter.setElementIndex(2);
					vsfilter.setup(context_);
				
					HighPassFilter highpassfilter=new HighPassFilter();
					highpassfilter.setSampleNum(256);
					highpassfilter.setCutoffFrequency(2);
					highpassfilter.setup(context_);
					
					// connect
					receiver.getOutputPort().connect(parser.getInputPort());
					parser.getOutputPort().connect(soreter.getInputPort());
					soreter.getOutputPort().connect(vsfilter.getInputPort());
					vsfilter.getOutputPort().connect(highpassfilter.getInputPort());
					highpassfilter.getOutputPort().connect(getWaveViewSink());
					
					
					// start
					context_.startTasks();
				}
			});
		}
		
		// stop
		{
			final Button b = new Button(pane3, SWT.BORDER);
			b.setText("stop");
			b.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					stopTasks();
				}
			});
		}
		
		// csv file output
		{
			final FileDialog fileDialog=new FileDialog(parent.getShell(), SWT.SAVE);
			fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc","*"});
			//
			final Button b = new Button(pane3, SWT.BORDER);
			b.setText("output CSV file:");
			b.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					csvOutputFileName_=fileDialog.open();
					csvOutputFileNameText_.setText(csvOutputFileName_!=null?csvOutputFileName_:"");
				}
			});
			csvOutputFileNameText_=new Text(pane3, SWT.BORDER | SWT.SINGLE);    
			csvOutputFileNameText_.setLayoutData(new RowData(50,SWT.DEFAULT));
		}
		
		// queue capacity
		{
			final Label l=new Label(pane3, SWT.NONE);
			l.setText("queue capacity:");
			queueCapacityText_ = new Text(pane3, SWT.BORDER | SWT.SINGLE);
			queueCapacityText_.setLayoutData(new RowData(50,SWT.DEFAULT));
		}
		
		// sleeper timeScale
		{
			final Label l=new Label(pane3, SWT.NONE);
			l.setText("sleeper time scale:");
			timeScaleText_ = new Text(pane3, SWT.BORDER | SWT.SINGLE);
			timeScaleText_.setText("1.0");
			timeScaleText_.setLayoutData(new RowData(50,SWT.DEFAULT));
		}    
	}
	
	private Text queueCapacityText_, timeScaleText_;
	
	private void stopTasks() {
		if (context_!=null) context_.stopTasks();
	}

	@Override
	public void setFocus() {
	}
	
	@Override
	public void dispose() {
		super.dispose();
		stopTasks();
	}
}
