package jp.hasc.hasctool.ui.views;

import jp.hasc.hasctool.core.messaging.MessageProcessor;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * VectorViewにデータを転送するBean
 * @author iwasaki
 */
public class RuntimeVectorView extends AbstractRuntimeWaveView {
	private VectorView vectorView_;

	@Override
	protected void setupView(IWorkbenchWindow window, String keyName) throws Exception {
		vectorView_=(VectorView) window.getActivePage().showView(VectorView.ID
				,keyName, IWorkbenchPage.VIEW_VISIBLE);
		vectorView_.setTitleName(keyName);
		vectorView_.setValueMin(getMinValue());
		vectorView_.setValueHeight(getMaxValue()-getMinValue());
	}
	
	public MessageProcessor getInputPort() {
		return vectorView_.getInputPort();
	}
}
