// based on GEF ShapesEditor example
/*******************************************************************************
 * Copyright (c) 2004, 2005 Elias Volanakis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Elias Volanakis - initial API and implementation
 *******************************************************************************/
package jp.hasc.hasctool.ui.bdeditor2.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import jp.hasc.hasctool.ui.bdeditor2.model.ConnectionElement;
import jp.hasc.hasctool.ui.bdeditor2.model.ModelElement;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;

/**
 * @author iwasaki
 */
public class ConnectionEditPart extends AbstractConnectionEditPart implements
		PropertyChangeListener {

	/**
	 * Upon activation, attach to the model element as a property change
	 * listener.
	 */
	@Override
	public void activate() {
		if (!isActive()) {
			super.activate();
			((ModelElement) getModel()).addPropertyChangeListener(this);
		}
	}

	@Override
	protected void createEditPolicies() {
		// Selection handle edit policy.
		// Makes the connection show a feedback, when selected by the user.
		installEditPolicy(EditPolicy.CONNECTION_ENDPOINTS_ROLE,
				new ConnectionEndpointEditPolicy());
		// Allows the removal of the connection model element
		installEditPolicy(EditPolicy.CONNECTION_ROLE,new ModelElementComponentEditPolicy());
	}

	@Override
	protected IFigure createFigure() {
		PolylineConnection connection = (PolylineConnection) super
				.createFigure();
		connection.setTargetDecoration(new PolygonDecoration()); // arrow at target endpoint
		return connection;
	}

	@Override
	public void deactivate() {
		if (isActive()) {
			super.deactivate();
			((ModelElement) getModel()).removePropertyChangeListener(this);
		}
	}

	public ConnectionElement getCastedModel() {
		return (ConnectionElement) getModel();
	}

	@Override
	public void propertyChange(PropertyChangeEvent event) {
		// String property = event.getPropertyName();
		//refreshVisuals();
	}
	
	@Override
	protected void refreshVisuals() {
		/* 動的変更への対応が面倒
		PolylineConnection connection=(PolylineConnection)getFigure();
		if (!getCastedModel().getSource().getBeanBlock().isEnabled() || 
			!getCastedModel().getTarget().getBeanBlock().isEnabled()
		){
			connection.setForegroundColor(ColorConstants.gray);
		}else{
			connection.setForegroundColor(ColorConstants.black);
		}
		*/
		super.refreshVisuals();
	}

}