package jp.hasc.hasctool.core.runtime.filter.weka.file;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;


/**
 * HASC Data を WEKA で読み込み可能な形式に変換します
 * @author hiro
 */
public class DataCreator extends AbstractFilter{

	//識別対象を指定
	String element_;
	String[] eList_;
	int eLength_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		eList_ = element_.split(",");
		eLength_ = eList_.length;
	}

	public void setElement(String element) {
		element_ = element;
	}

	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {

			//message = filePath+","+featureData[]
			String s = (String)message;
			String[] val = s.split(",");
			String filePath = val[0];

			//element情報をget
			String element = null;
			for(int i=0; i<eLength_; i++){
				if (0 <= filePath.indexOf(eList_[i])){
					element = eList_[i];
				}
			}

			//feature情報をget
			//val[1]はtime
			int len = val.length;
			String feature = "";
			for(int i=2; i<len; i++){
				if(i == 2){
					feature += val[i];
				} else {
					feature += "," + val[i];
				}
			}
			if(element != null){
				outputMessage(feature + "," + element);
			}

		} else {
			// その他のメッセージはそのまま出力
			outputMessage(message);
		}
	}
}
