package jp.hasc.hasctool.core.runtime.filter.weka.label;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * abstractClass
 * labelを修正するフィルタです
 * 入力はfilePath,label
 * @author hiro
 */
public abstract class LabelModifier extends AbstractFilter{

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	abstract String modify(String label);

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String[] dpart = s.split(",");
			String filePath = dpart[0];
			String label = dpart[1];
			outputMessage(filePath + "," + modify(label));
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}
}
