package jp.hasc.hasctool.core.data;

/**
 * スカラ（サイズ１のベクトル）信号の値です
 * @author iwasaki,hiro
 */
public class ScalarSignalMessage extends AbstractSignalMessage implements VectorSignalMessage {

	private double scalarValue_;

	public ScalarSignalMessage(long time, double scalarValue) {
		super(time);
		scalarValue_ = scalarValue;
	}

	public double getScalarValue() {
		return scalarValue_;
	}

	@Override
	public double getVectorElement(int index) {
		if (index!=0) throw new ArrayIndexOutOfBoundsException();
		return scalarValue_;
	}

	@Override
	public double getVectorNorm() {
		return Math.abs(scalarValue_);
	}

	@Override
	public int getVectorSize() {
		return 1;
	}

	@Override
	public SignalMessage createDelayedElement(long delay) {
		if (delay==0) return this;
		return new ScalarSignalMessage(getTime()+delay, scalarValue_);
	}

	@Override
	public String toString() {
		return "{time:"+getTime()+", value:"+scalarValue_+"}";
	}

	/** auto generated */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		long temp;
		temp = Double.doubleToLongBits(scalarValue_);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		return result;
	}

	/** auto generated */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		ScalarSignalMessage other = (ScalarSignalMessage) obj;
		if (Double.doubleToLongBits(scalarValue_) != Double
				.doubleToLongBits(other.scalarValue_))
			return false;
		return true;
	}

}
