package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.RuntimeBean;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * 抽象クラスを継承しないで作られた、シンプルなフィルタ例。スカラ値に、valutToAddプロパティの値を加算する
 * @author iwasaki
 */
public class SampleFilter2 implements RuntimeBean, MessageProcessor {
	
	// valueToAdd プロパティ
	private double valueToAdd_ = 0;
	public double getValueToAdd() { return valueToAdd_; }
	public void setValueToAdd(double valueToAdd) { valueToAdd_ = valueToAdd; }
	
	// outputPort
	private MessageConnector outputPort_ = new MessageConnector();
	public MessageConnector getOutputPort() { return outputPort_; }
	
	// inputPort
	public MessageProcessor getInputPort() { return this; }
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof ScalarSignalMessage) {
			// ScalarSignalMessageの場合
			ScalarSignalMessage inValue=(ScalarSignalMessage)message;
			// 新しい値を計算
			double newValue = inValue.getScalarValue() + valueToAdd_;
			// 結果を出力
			outputPort_.processMessage(new ScalarSignalMessage(inValue.getTime(), newValue));
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputPort_.processMessage(message);
		}
	}
	
	@Override
	public void setup(RuntimeContext context) {}
}
