package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.interpolator.AbstractMultipleInputsFilter;
import jp.hasc.hasctool.core.runtime.filter.interpolator.LinearVectorInterporator;
import jp.hasc.hasctool.core.runtime.filter.interpolator.SignalInterpolator;

/**
 * 複数のベクトルを連結するフィルタです。
 * @author iwasaki
 */
public class VectorConcatenater extends AbstractMultipleInputsFilter {

	@Override
	public SignalInterpolator createSignalInterpolator(int portIndex) {
		return new LinearVectorInterporator();
	}
	
	@Override
	protected boolean acceptSignalMessage(int portIndex, SignalMessage signalMessage) {
		return signalMessage instanceof VectorSignalMessage;
	}

	@Override
	protected void processSignalMessages(long time, SignalMessage[] messages) throws InterruptedException {
		int valsize=0;
		for(int i=0;i<messages.length;++i) {
			valsize+=((VectorSignalMessage)messages[i]).getVectorSize();
		}
		double[] val=new double[valsize];
		int vi=0;
		for(int i=0;i<messages.length;++i) {
			VectorSignalMessage vse = (VectorSignalMessage)messages[i];
			for(int j=0;j<vse.getVectorSize();++j) val[vi++]=vse.getVectorElement(j);
		}
		outputMessage(VectorSignalMessages.create(time, val, false));
	}

}
