package jp.hasc.hasctool.core.runtime.filter.count;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 歩数カウントを行うフィルタです。
 * @author hiro
 */
public class wnCounter extends AbstractFilter{

	long time_ = 0;
	boolean state_ = false;
	int count_ = 0;
	double low_ = 0.85;//0.85G
	double high_ = 1.15;//1.15G
	int k = 1000;
	int tick_ = 1*k*k;
	boolean start_ = true;
	long startT_;
	long endT_;

	/*http://www.hdk.co.jp/pdf/AP_Note/anhaam04_v1.01.pdf*/
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			// ScalarSignalMessageの場合
			ScalarSignalMessage ssig=(ScalarSignalMessage)message;
			double val = ssig.getScalarValue();
			if(start_){
				startT_ = ssig.getTime();
				start_ = false;
			}
			endT_ = ssig.getTime();
			
			if(state_==false){
				if(val<=low_){
					time_ = ssig.getTime();
					state_ = true;
				}
			} else if(state_==true){
				if((ssig.getTime()-time_) <= tick_){
					if(val>=high_){
						count_++;
						state_ = false;
					}
				}else{
					state_ = false;
				}
			}
		} else if (message == EnumCommand.END) {
			//歩数，計測時間，歩数率
			outputMessage("A Number Of walk is :" + count_+","+(endT_-startT_)/(k*k)+","+(count_*k*k)/(double)(endT_-startT_));
			outputMessage(EnumCommand.END);
		} else {
			//BEGIN message
			outputMessage(message);
		}
	}
}
