package jp.hasc.hasctool.core.runtime.filter.file;

import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.AbstractRuntimeBean;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * HascLoggerログファイルの文字列系列から、加速度ログを取り出し、VectorSignalとして出力するフィルタです
 * @author iwasaki
 */
public class HascLogAccToVectorFilter extends AbstractRuntimeBean implements MessageProcessor {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(HascLogAccToVectorFilter.class);
	
	public MessageProcessor getInputPort() { return this; }
	
	private int logVersion_=0;
	private CSVToVectorFilter csvFilter_=new CSVToVectorFilter();
	
	public MessageConnector getOutputPort() { return csvFilter_.getOutputPort(); }
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		csvFilter_.setup(context);
	}
	
	private void outputMessage(Object message) throws InterruptedException {
		csvFilter_.processMessage(message);
	}
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String line=(String)message;
			String[] clms = line.split("\t");
			String rowtype = clms[1];
			if (rowtype.equals("ACC")) {
				outputMessage(clms[2]); // 加速度信号
			}else if (rowtype.equals("TAGS")) {
				if (logVersion_==0) {
					logVersion_=1;
					csvFilter_.setTimeColumnIndex(-1); // 旧版
					LOG.debug("HascLogVer:"+logVersion_);
				}
			}else if (rowtype.equals("LOG_VERSION")) {
				logVersion_=Integer.parseInt(clms[2]);
				LOG.debug("HascLogVer:"+logVersion_);
			}
		}else{
			outputMessage(message);
		}
	}

}
