package jp.hasc.hasctool.core.runtime.filter.file;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * HascLoggerログファイルの文字列系列から、指定のタグ（ACC,GYRO）を持ったメッセージ（CSV）を、文字列系列として出力するフィルタです
 * @author iwasaki
 */
public class HascLogTagFilter extends AbstractFilter {
	private String tag_ = "ACC";
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String line=(String)message;
			String[] clms = line.split("\t");
			if (clms.length>=3) {
				String rowtype = clms[1];
				if (rowtype.equals(tag_)) {
					outputMessage(clms[2]);
				}
			}
		}else{
			outputMessage(message);
		}
	}

	public String getTag() {
		return tag_;
	}

	public void setTag(String tag) {
		tag_ = tag;
	}
}
