package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.data.Complex;
import jp.hasc.hasctool.core.data.ComplexVectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 逆フーリエ変換を行うフィルタです
 * @author hiro
 */

public class InverseFFTFilter extends AbstractFilter {

	private FFT fft;//FFT

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof ComplexVectorSignalMessage) {
			// ComplexVectorSignalMessageの場合
			VectorSignalMessage cvsig=(VectorSignalMessage)message;
			// 新しいベクトルの値を計算
			Complex[] data = new Complex[cvsig.getVectorSize()];
			for(int i=0; i<data.length; i++){
				data[i]= ((ComplexVectorSignalMessage)cvsig).getVectorValue(i);
			}
			fft = new FFT(true);
			fft.setdata(data);
			fft.execute();
			Complex[] data2 = fft.getdata();
			int len = data2.length - data2.length/2;
			double newValue = data2[len].re();
			// 結果を出力
			outputMessage(VectorSignalMessages.createScalar(cvsig.getTime(), newValue));
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}
}
