package jp.hasc.hasctool.core.runtime.filter.interpolator;

import java.util.ArrayList;
import java.util.List;

import jp.hasc.hasctool.core.data.NullSignalMessage;
import jp.hasc.hasctool.core.data.ObjectSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;

/**
 * 前回の時刻（同時刻含まない）から今回の時刻（同時刻含む）までに入力された全てのSignalMessageを、配列として出力するSignalInterpolatorです。
 * NullSignalMessageの入力は削除されます。
 * @author iwasaki
 */
public class MessageArrayInterpolator implements SignalInterpolator {
	
	private ArrayList<SignalMessage> buff_=new ArrayList<SignalMessage>();
	public static final SignalMessage[] EMPTY_ARRAY=new SignalMessage[0];

	@Override
	public boolean addSample(SignalMessage message) {
		if (message instanceof NullSignalMessage) return true; // falseを返すと、時刻が進まない
		buff_.add(message);
		return true;
	}

	@Override
	public SignalMessage getAtTime(long time) {
		int i=0,buffSize=buff_.size();
		for(;i<buffSize;++i) {
			if (buff_.get(i).getTime()>time) break;
		}
		SignalMessage[] ar;
		if (i==0) ar=EMPTY_ARRAY;
		else {
			List<SignalMessage> subList = buff_.subList(0, i);
			ar=subList.toArray(new SignalMessage[i]);
			subList.clear();
		}
		
		return new ObjectSignalMessage(time, ar);
	}

}
