package jp.hasc.hasctool.core.runtime.filter.label;

import jp.hasc.hasctool.core.data.LabelInfo;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.tick.TickEmitter;

/**
 * SignalMessageを入力し、ラベル（LabelSignalMessage）を出力するフィルタのためのsuper classです
 * @author iwasaki
 */
public abstract class AbstractLabelingFilter extends AbstractFilter{
	
	private String targetFilePath_=null;
	private TickEmitter tickEmitter_=null;
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof SignalMessage) {
			SignalMessage sig = (SignalMessage)message;
			processSignalMessage(sig);
			if (tickEmitter_!=null) tickEmitter_.afterProcessSignalMessage(sig);
		}else if (message==SignalMessage.BEGIN) {
			outputMessage(message);
			// ヘッダを出力
			if (targetFilePath_!=null) {
				outputMessage(LabelInfo.HEADER_PREFIX_TARGET_FILE + targetFilePath_);
			}
		}else{
			outputMessage(message);
		}    
	}

	@Override
	protected void outputMessage(Object message) throws InterruptedException {
		if (message instanceof SignalMessage) {
			SignalMessage sig = (SignalMessage)message;
			if (tickEmitter_!=null) tickEmitter_.onOutputSignalMessage(sig);
		}
		super.outputMessage(message);
	}

	protected abstract void processSignalMessage(SignalMessage message) throws InterruptedException;

	public void setTickEmitter(TickEmitter tickEmitter) {
		tickEmitter_ = tickEmitter;
		tickEmitter_.setInputPortToOutputMessage(getInputPortToOutputMessage());
	}
	
	//
	
	public String getTargetFilePath() {
		return targetFilePath_;
	}

	public void setTargetFilePath(String targetFileName) {
		targetFilePath_ = targetFileName;
	}

	public TickEmitter getTickEmitter() {
		return tickEmitter_;
	}
}
