package jp.hasc.hasctool.core.runtime.filter.time;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * TimeParserです
 * input:hour+minute+millisec
 * output:sec
 * @author hiro
 */

public class TimeParserFilter extends AbstractFilter{

	long timeParse(long time){
		int μ = 1000000;//VectorSignalMessageでは時間の単位が(μsec)となっているため
		int m = 1000;
		double val = time/μ;
		val /= m;
		int hour = (int)(val/10000);
		int minute = (int)(val/100) - hour*100;
		double sec = val - (hour*10000 + minute*100);
		double newVal = hour*3600 + minute*60 + sec;
		return (long)(newVal*μ);
	}
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			// VectorSignalMessageの場合
			VectorSignalMessage vsig=(VectorSignalMessage)message;
			// 新しいベクトルの値を計算
			double[] newValue=new double[vsig.getVectorSize()];
			for(int i=0; i<newValue.length; ++i){
				newValue[i] = vsig.getVectorElement(i);
			}
			//TimeParserを実行する
			long newTime = timeParse(vsig.getTime());
			// 結果を出力
			outputMessage(VectorSignalMessages.create(newTime, newValue));
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}

}
