package jp.hasc.hasctool.core.util;

/**
 * @author iwasaki
 */
public class Pair<F,S> {
	private F first_;
	private S second_;
	
	public Pair(F first, S second) {
		super();
		first_ = first;
		second_ = second;
	}
	
	public F getFirst() {
		return first_;
	}
	
	public S getSecond() {
		return second_;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((first_ == null) ? 0 : first_.hashCode());
		result = prime * result + ((second_ == null) ? 0 : second_.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		@SuppressWarnings("rawtypes")
		Pair other = (Pair) obj;
		if (first_ == null) {
			if (other.first_ != null)
				return false;
		} else if (!first_.equals(other.first_))
			return false;
		if (second_ == null) {
			if (other.second_ != null)
				return false;
		} else if (!second_.equals(other.second_))
			return false;
		return true;
	}

}
