package jp.hasc.hasctool.ui.commands;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import org.eclipse.core.resources.IContainer;

import jp.hasc.hasctool.core.runtime.FileStreamProvider;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * パス名によって以下のように実装を切り替える{@link FileStreamProvider}です。
 *   "rawfile:"が頭につく => {@link RawFileStreamProvider}
 *   その他 => {@link ResourceStreamProvider}
 * @author iwasaki
 */
public class HybridStreamProvider implements FileStreamProvider {
	
	private ResourceStreamProvider resourceSp_;
	private RawFileStreamProvider rawFileSp_;
	
	public HybridStreamProvider(IContainer baseContainer,
			RuntimeContext runtimeContext) {
		resourceSp_=new ResourceStreamProvider(baseContainer, runtimeContext);
		rawFileSp_=new RawFileStreamProvider(baseContainer, runtimeContext);
	}

	@Override
	public InputStream openInputStream(String path) {
		if (RawFileStreamProvider.isPathMatches(path)) {
			return rawFileSp_.openInputStream(path);
		}else{
			return resourceSp_.openInputStream(path);
		}
	}

	@Override
	public OutputStream openOutputStream(String path) {
		if (RawFileStreamProvider.isPathMatches(path)) {
			return rawFileSp_.openOutputStream(path);
		}else{
			return resourceSp_.openOutputStream(path);
		}
	}

	@Override
	public void listFileNames(String folderPath, List<String> out) {
		if (RawFileStreamProvider.isPathMatches(folderPath)) {
			rawFileSp_.listFileNames(folderPath,out);
		}else{
			resourceSp_.listFileNames(folderPath,out);
		}
	}

	@Override
	public void listSubFolderNames(String folderPath, List<String> out) {
		if (RawFileStreamProvider.isPathMatches(folderPath)) {
			rawFileSp_.listSubFolderNames(folderPath,out);
		}else{
			resourceSp_.listSubFolderNames(folderPath,out);
		}
	}

}
