package jp.hasc.hasctool.ui.views.beanslist;

import java.util.Collection;

import jp.hasc.hasctool.ui.util.UIUtil;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;

/**
 * Beans一覧を表示するビューです
 * @author iwasaki
 */
public class BeansListWidget extends Composite {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(BeansListWidget.class);
	
	private BeansListView owner_;

	private BeansListContentProvider contentProvider_;
	
	public BeansListWidget(BeansListView owner, Composite parentComposite, int style) {
		super(parentComposite, style);
		owner_=owner;
		//
		Collection<BeansFolder> list = new BeansListLoader().makeModel();
		this.setLayout(new FormLayout());
		
		final Text searchText=new Text(this, SWT.SEARCH | SWT.ICON_CANCEL);
		{
			FormData fd = new FormData();
			fd.top=new FormAttachment(0, 1);
			fd.left=new FormAttachment(0, 1);
			fd.right=new FormAttachment(100, -1);
			searchText.setLayoutData(fd);
		}
		
		final TreeViewer treeViewer=new TreeViewer(this, SWT.H_SCROLL|SWT.V_SCROLL|SWT.BORDER);
		{
			FormData fd = new FormData();
			fd.top=new FormAttachment(searchText, 1);
			fd.left=new FormAttachment(0, 1);
			fd.right=new FormAttachment(100, -1);
			fd.bottom=new FormAttachment(100, -1);
			treeViewer.getControl().setLayoutData(fd);
		}
		contentProvider_ = new BeansListContentProvider();
		treeViewer.setContentProvider(contentProvider_);
		treeViewer.setLabelProvider(new BeansListLabelProvider());
		treeViewer.setInput(list);
		treeViewer.addDoubleClickListener(new IDoubleClickListener() {
			@Override
			public void doubleClick(DoubleClickEvent event) {
				BeanClass m = getClassModelFromSelection(event.getSelection());
				if (m!=null) addBean(m.getClassName());
			}
		});
		
		searchText.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				if (e.keyCode==SWT.ESC) {
					searchText.setText("");
					contentProvider_.setSearcher(StringSearcher.NULL_SEARCHER);
					treeViewer.refresh();
				}
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
			}
		});
		
		searchText.addSelectionListener(new SelectionAdapter() {
			public void widgetDefaultSelected(SelectionEvent e) {
				if (e.detail == SWT.CANCEL) {
					//LOG.debug("Search cancelled");
					contentProvider_.setSearcher(StringSearcher.NULL_SEARCHER);
					treeViewer.refresh();
				} else {
					//LOG.debug("Searching for: " + searchText.getText());
					try{
						StringSearcher searcher = new StringSearcher(searchText.getText());
						contentProvider_.setSearcher(searcher);
					}catch(Exception ex) {
						UIUtil.showMessageDialog(getShell(), ex.toString());
					}
					treeViewer.refresh();
				}
			}
		});
	}
	
	private BeanClass getClassModelFromSelection(ISelection s) {
		if (s instanceof StructuredSelection) {
			StructuredSelection ss = (StructuredSelection) s;
			Object v = ss.getFirstElement();
			if (v instanceof BeanClass) {
				BeanClass m = (BeanClass) v;
				return m;
			}
		}
		return null;
	}
	
	private void addBean(String clsName) {
		LOG.debug("add "+clsName); //$NON-NLS-1$
		IEditorPart te = owner_.getActiveEditor();
		if (te instanceof IBeansListTarget) {
			IBeansListTarget bde = (IBeansListTarget) te;
			bde.addBeanBlock(clsName);
		}else{
			UIUtil.showMessageDialog(getShell(), Messages.BeansListWidget_cantFindBlockDiagramEditor);
		}
	}
}
