/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package jp.sourceforge.jpnvalidator.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import junit.framework.TestCase;

/**
 * FileResourceUtilTest<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class FileResourceUtilTest extends TestCase
{
	// *** テスト仕様 ***
	//
	// N001 : 通常パターンでresourceがcloseされる事
	// N002 : resorceがnullの場合に正常に処理できる事
	//
	// *** テスト対象 ***
	//
	// FileResourceUtil#close(BufferedInputStream)
	// FileResourceUtil#close(BufferedReader)
	// FileResourceUtil#close(InputStream)
	// FileResourceUtil#close(InputStreamReader)

	private static final String TEST_DATA_PATH = "src/test/resources/jp/sourceforge/jpnvalidator/util/file/FileResourceUtilTestData/";

	public void test_close_BufferedInputStream_N001_normal() throws Exception
	{
		String methodName = new Throwable().getStackTrace()[0].getMethodName();
		String filepath = TEST_DATA_PATH + methodName + ".txt";
		InputStream is = null;
		BufferedInputStream bis = null;
		try
		{
			is = new FileInputStream(filepath);
			bis = new BufferedInputStream(is);
		} finally
		{
			FileResourceUtil.close(bis);
		}
		try
		{
			bis.available();
			fail("stream is not closed");
		} catch (IOException e)
		{
		}
	}

	public void test_close_BufferedInputStream_N002_null() throws Exception
	{
		BufferedInputStream bis = null;
		FileResourceUtil.close(bis);
	}

	public void test_close_BufferedReader_N001_normal() throws Exception
	{
		String methodName = new Throwable().getStackTrace()[0].getMethodName();
		String filepath = TEST_DATA_PATH + methodName + ".txt";
		InputStream is = null;
		BufferedReader br = null;
		try
		{
			is = new FileInputStream(filepath);
			br = new BufferedReader(new InputStreamReader(is));
		} finally
		{
			FileResourceUtil.close(br);
		}
		try
		{
			br.ready();
			fail("stream is not closed");
		} catch (IOException e)
		{
		}
	}

	public void test_close_BufferedReader_N002_null() throws Exception
	{
		BufferedReader br = null;
		FileResourceUtil.close(br);
	}

	public void test_close_InputStream_N001_normal() throws Exception
	{
		String methodName = new Throwable().getStackTrace()[0].getMethodName();
		String filepath = TEST_DATA_PATH + methodName + ".txt";
		InputStream is = null;
		try
		{
			is = new FileInputStream(filepath);
		} finally
		{
			FileResourceUtil.close(is);
		}
		try
		{
			is.available();
			fail("stream is not closed");
		} catch (IOException e)
		{
		}
	}

	public void test_close_InputStream_N002_null() throws Exception
	{
		InputStream is = null;
		FileResourceUtil.close(is);
	}

	public void test_close_InputStreamReader_N001_normal() throws Exception
	{
		String methodName = new Throwable().getStackTrace()[0].getMethodName();
		String filepath = TEST_DATA_PATH + methodName + ".txt";
		InputStream is = null;
		InputStreamReader isr = null;
		try
		{
			is = new FileInputStream(filepath);
			isr = new InputStreamReader(is);
		} finally
		{
			FileResourceUtil.close(isr);
		}
		try
		{
			isr.ready();
			fail("stream is not closed");
		} catch (IOException e)
		{
		}
	}

	public void test_close_InputStreamReader_N002_null() throws Exception
	{
		InputStreamReader isr = null;
		FileResourceUtil.close(isr);
	}

}
