/*
 * TODO 未テスト
 */
package jp.kirikiri.tjs2;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashSet;

public class NativeJavaClass extends NativeClass {

	private Class<?> mJavaClass;
	private int mClassID;

	public NativeJavaClass( String name, Class<?> c ) throws VariantException, TJSException {
		super(name);
		mJavaClass = c;

		String classname = name;
		mClassID = TJS.registerNativeClass(classname);
		try {
			HashSet<String> registProp = new HashSet<String>(); // set/getで重複しないようにチェック

			Method[] methods = c.getMethods();
			for( Method m : methods ) {
				final String methodName = m.getName();
				final int modif = m.getModifiers();
				int flag = 0;
				if( Modifier.isStatic( modif ) ) flag |= Interface.STATICMEMBER;

				if( "constructor" .equals( methodName ) ) {
					// コンストラクタ
					registerNCM( classname, new NativeJavaClassConstructor(m, mClassID), classname, Interface.nitMethod, flag );
				} else if( methodName.startsWith("prop_") ) {
					// プロパティ prop_ で始まるものはプロパティとみなす
					@SuppressWarnings("rawtypes")
					Class[] params = m.getParameterTypes();
					Method setMethod = null;
					Method getMethod = null;
					String propName = null;
					if( methodName.startsWith("prop_set_") ) {
						if( params.length == 1 ) {
							setMethod = m;
							propName = methodName.substring( "prop_set_".length() );
							if( registProp.contains(propName) == false ) {
								final String getMethodName = "prop_get_" + propName;
								for( Method getm : methods ) {
									if( getm.getName().equals( getMethodName ) ) {
										@SuppressWarnings("rawtypes")
										Class[] p = getm.getParameterTypes();
										if( p.length == 0 && getm.getReturnType().equals(void.class) != true ) {
											getMethod = getm;
											break;
										}
									}
								}
							}
						}
					} else if( methodName.startsWith("prop_get_") ) {
						if( params.length == 0 && m.getReturnType().equals(void.class) != true ) {
							getMethod = m;
							propName = methodName.substring( "prop_get_".length() );
							if( registProp.contains(propName) == false ) {
								final String setMethodName = "prop_set_" + propName;
								for( Method setm : methods ) {
									if( setm.getName().equals( setMethodName ) ) {
										@SuppressWarnings("rawtypes")
										Class[] p = setm.getParameterTypes();
										if( p.length == 1 ) {
											setMethod = setm;
											break;
										}
									}
								}
							}
						}
					}
					if( propName != null && registProp.contains(propName) == false ) {
						if( setMethod != null || getMethod != null ) {
							registerNCM( propName, new NativeJavaClassProperty(getMethod, setMethod, mClassID), classname, Interface.nitProperty, flag );
							registProp.add(propName);
						}
					}
				} else {
					// 通常メソッド
					registerNCM( methodName, new NativeJavaClassMethod(m, mClassID), classname, Interface.nitMethod, flag );
				}
			}
			registProp = null;
		} catch (SecurityException e) {
			throw new TJSException(Error.InternalError + e.toString());
		}
	}
	/**
	 * 引数があるコンストラクタには未対応
	 * TODO エラー時エラー表示するようにした方がいいかも
	 */
	protected NativeInstance createNativeInstance() {
		Object obj;
		try {
			obj = mJavaClass.newInstance();
		} catch (InstantiationException e) {
			TJS.outputExceptionToConsole( e.toString() );
			return null;
		} catch (IllegalAccessException e) {
			TJS.outputExceptionToConsole( e.toString() );
			return null;
		}
		if( obj != null ) {
			return new NativeJavaInstance(obj);
		}
		return null;
	}
	static public Object variantToJavaObject( Variant param, Class<?> type ) throws VariantException {
		if( type.isPrimitive() ) { // プリミティブタイプの場合
			if( type.equals( Integer.TYPE ) ) {
				return Integer.valueOf( param.asInteger() );
			} else if( type.equals( Double.TYPE ) ) {
				return Double.valueOf( param.asDouble() );
			} else if( type.equals( Boolean.TYPE ) ) {
				return Boolean.valueOf( param.asInteger() != 0 ? true : false );
			} else if( type.equals( Float.TYPE ) ) {
				return Float.valueOf( (float)param.asDouble() );
			} else if( type.equals( Long.TYPE ) ) {
				return Long.valueOf( param.asInteger() );
			} else if( type.equals( Character.TYPE ) ) {
				return Character.valueOf( (char)param.asInteger() );
			} else if( type.equals( Byte.TYPE ) ) {
				return Byte.valueOf( (byte)param.asInteger() );
			} else if( type.equals( Short.TYPE ) ) {
				return Short.valueOf( (short)param.asInteger() );
			} else { // may be Void.TYPE
				return null;
			}
		} else if( type.equals( String.class ) ) {
			return param.asString();
		} else if( type.equals( ByteBuffer.class ) ) {
			return param.asOctet();
		} else if( type.equals( Variant.class ) ) {
			return param;
		} else if( type.equals( VariantClosure.class ) ) {
			return param.asObjectClosure();
		} else if( type.equals( Dispatch2.class ) ) {
			return param.asObject();
		} else if( type.equals( param.toJavaObject().getClass() )) {
			return param.toJavaObject();
		} else {
			// その他 のクラス
			return null;
		}
	}
	static public void javaObjectToVariant( Variant result, Class<?> type, Object src ) {
		if( result == null ) return;
		if( type.isPrimitive() ) { // プリミティブタイプの場合
			if( type.equals( Integer.TYPE ) ) {
				result.set( ((Integer)src).intValue() );
			} else if( type.equals( Double.TYPE ) ) {
				result.set( ((Double)src).doubleValue() );
			} else if( type.equals( Boolean.TYPE ) ) {
				result.set( ((Boolean)src).booleanValue() ? 1 : 0 );
			} else if( type.equals( Float.TYPE ) ) {
				result.set( ((Float)src).doubleValue() );
			} else if( type.equals( Long.TYPE ) ) {
				result.set( ((Long)src).intValue() );
			} else if( type.equals( Character.TYPE ) ) {
				result.set( (int)((Character)src).charValue() );
			} else if( type.equals( Byte.TYPE ) ) {
				result.set( ((Byte)src).intValue() );
			} else if( type.equals( Short.TYPE ) ) {
				result.set( ((Short)src).intValue() );
			} else { // may be Void.TYPE
				result.clear();
			}
		} else if( type.equals( String.class ) ) {
			result.set( (String)src );
		} else if( type.equals( ByteBuffer.class ) ) {
			result.set( (ByteBuffer)src );
		} else if( type.equals( Variant.class ) ) {
			result.set( (Variant)src );
		} else if( type.equals( VariantClosure.class ) ) {
			result.set( ((VariantClosure)src).mObject, ((VariantClosure)src).mObjThis );
		} else if( type.equals( Dispatch2.class ) ) {
			result.set( (Dispatch2)src );
		} else {
			// その他 のクラス, 直接入れてしまう
			result.setJavaObject( src );
		}
	}
	static public Object[] variantArrayToJavaObjectArray( Variant[] params, Class<?>[] types ) throws VariantException {
		if( types.length == 0 ) return null; // 元々引数不要
		if( params.length < types.length ) return null; // パラメータが少ない

		final int count = types.length;
		Object[] ret = new Object[count];
		for( int i = 0; i < count; i++ ) {
			Class<?> type = types[i];
			Variant param = params[i];
			if( type.isPrimitive() ) { // プリミティブタイプの場合
				if( type.equals( Integer.TYPE ) ) {
					ret[i] = Integer.valueOf( param.asInteger() );
				} else if( type.equals( Double.TYPE ) ) {
					ret[i] = Double.valueOf( param.asDouble() );
				} else if( type.equals( Boolean.TYPE ) ) {
					ret[i] = Boolean.valueOf( param.asInteger() != 0 ? true : false );
				} else if( type.equals( Float.TYPE ) ) {
					ret[i] = Float.valueOf( (float)param.asDouble() );
				} else if( type.equals( Long.TYPE ) ) {
					ret[i] = Long.valueOf( param.asInteger() );
				} else if( type.equals( Character.TYPE ) ) {
					ret[i] = Character.valueOf( (char)param.asInteger() );
				} else if( type.equals( Byte.TYPE ) ) {
					ret[i] = Byte.valueOf( (byte)param.asInteger() );
				} else if( type.equals( Short.TYPE ) ) {
					ret[i] = Short.valueOf( (short)param.asInteger() );
				} else { // may be Void.TYPE
					ret[i] = null;
				}
			} else if( type.equals( String.class ) ) {
				ret[i] = param.asString();
			} else if( type.equals( ByteBuffer.class ) ) {
				ret[i] = param.asOctet();
			} else if( type.equals( Variant.class ) ) {
				ret[i] = param;
			} else if( type.equals( VariantClosure.class ) ) {
				ret[i] = param.asObjectClosure();
			} else if( type.equals( Dispatch2.class ) ) {
				ret[i] = param.asObject();
			} else if( type.equals( param.toJavaObject().getClass() )) {
				ret[i] = param.toJavaObject();
			} else {
				// その他 のクラス
				ret[i] = null;
			}
		}
		return ret;
	}
}

