package com.kurukurupapa.tryandroid.fw;

import java.util.ArrayList;

import android.content.Context;
import android.widget.ListAdapter;
import android.widget.SimpleAdapter;

/**
 * ListAdapter用リストデータ
 *
 * ListViewではListAdapter経由でリスト表示のデータにアクセスする。
 * 当クラスでは、ListAdapterでアクセス可能な形式のデータを保持する。
 */
public class MapListForListAdapter<T extends MapForListAdapter> extends
		ArrayList<T> {
	/**
	 * シリアルバージョンID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 1行表示ListAdapter作成
	 *
	 * @param context
	 * @return
	 */
	public ListAdapter createAdapterAsSimpleLine(Context context) {
		return new SimpleAdapter(context, this,
				android.R.layout.simple_list_item_1,
				new String[] { MapForListAdapter.KEY_TEXT1 },
				new int[] { android.R.id.text1 });
	}

	/**
	 * ２行表示（１行目が大フォント）ListAdapter作成
	 *
	 * @param context
	 * @return
	 */
	public ListAdapter createAdapterAsSimpleLine2(Context context) {
		return new SimpleAdapter(context, this,
				android.R.layout.simple_list_item_2, new String[] {
						MapForListAdapter.KEY_TEXT1,
						MapForListAdapter.KEY_TEXT2 }, new int[] {
						android.R.id.text1, android.R.id.text2 });
	}

	/**
	 * ２行表示（１,2行目が通常フォント）ListAdapter作成
	 *
	 * @param context
	 * @return
	 */
	public ListAdapter createAdapterAsTwoLine(Context context) {
		return new SimpleAdapter(context, this,
				android.R.layout.two_line_list_item, new String[] {
						MapForListAdapter.KEY_TEXT1,
						MapForListAdapter.KEY_TEXT2 }, new int[] {
						android.R.id.text1, android.R.id.text2 });
	}
}
