package com.kurukurupapa.tryandroid.fw.model;

import com.kurukurupapa.tryandroid.fw.annotation.Exclude;
import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.kurukurupapa.tryandroid.fw.util.PreferenceUtil;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;

/**
 * プリファレンスデータ
 */
public class FwPreference {
	@Exclude
	private Context context;

	/**
	 * バージョン<br>
	 * 初期インストール直後は0とする
	 */
	public int versionCode = 0;

	public FwPreference(Context context) {
		this.context = context;
	}

	public void load() {
		PreferenceUtil.copyPreferenceDto(context, this);
	}

	public void save() {
		PreferenceUtil.putPreferenceDto(context, this);
	}

	public boolean isFirstInstall() {
		return versionCode <= 0;
	}

	public boolean isVersionUp() {
		return versionCode < getVersionCode();
	}

	public void setVersionCode() {
		versionCode = getVersionCode();
	}

	private int getVersionCode() {
		int versionCode = 0;

		try {
			PackageInfo packageInfo = context.getPackageManager()
					.getPackageInfo(context.getPackageName(),
							PackageManager.GET_META_DATA);
			versionCode = packageInfo.versionCode;
		} catch (NameNotFoundException e) {
			LogUtil.e("AndroidManifest.xmlからのversionCode取得エラー", e);
		}

		return versionCode;
	}
}
