package com.kurukurupapa.tryandroidui002;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

/**
 * アクティビティのタイトルバー部分を動的に切り替える実験プログラム<br>
 * AndroidManifest.xmlの設定のまま（Java側で何も処理しない）場合。
 */
public class NothingActivity extends Activity {

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d(getClass().getName(), getClass().getSimpleName() + "#onCreate()");

		// 親クラスのonCreate()を呼ぶ前にスリープを入れて、表示状態を確認する。
		sleep(1000);
		super.onCreate(savedInstanceState);

		// レイアウト設定
		setContentView(R.layout.activity);

		// コンテンツ設定
		TextView textView = (TextView) findViewById(R.id.textView1);
		textView.setText(getResources().getString(R.string.hello));
	}

	private void sleep(long time) {
		try {
			Thread.sleep(time);
		} catch (InterruptedException e) {
			Log.d(getClass().getName(), getClass().getSimpleName()
					+ "#onCreate()," + e.getMessage());
		}
	}
}