/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.test.testserver;

import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mmocore.network.HeaderInfo;
import org.mmocore.network.IClientFactory;
import org.mmocore.network.IMMOExecutor;
import org.mmocore.network.IPacketHandler;
import org.mmocore.network.MMOConnection;
import org.mmocore.network.ReceivablePacket;
import org.mmocore.network.TCPHeaderHandler;
import org.mmocore.test.testserver.ServerClient;
import org.mmocore.test.testserver.TestRecvPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorHelper
extends TCPHeaderHandler<ServerClient>
implements IPacketHandler<ServerClient>,
IMMOExecutor<ServerClient>,
IClientFactory<ServerClient> {
    ExecutorService _tpe = Executors.newFixedThreadPool(4);

    public SelectorHelper() {
        super(null);
    }

    @Override
    public ReceivablePacket<ServerClient> handlePacket(ByteBuffer buf, ServerClient client) {
        return new TestRecvPacket();
    }

    @Override
    public void execute(ReceivablePacket<ServerClient> packet) {
        this._tpe.execute(packet);
    }

    @Override
    public ServerClient create(MMOConnection<ServerClient> con) {
        System.out.println("new client");
        ServerClient sc = new ServerClient(con);
        return sc;
    }

    @Override
    public HeaderInfo<ServerClient> handleHeader(SelectionKey key, ByteBuffer buf) {
        int avaliable = buf.remaining();
        if (avaliable >= 2) {
            int dataSize = buf.getShort() & 0xFFFF;
            System.err.println("DATASIZE: " + dataSize);
            return this.getHeaderInfoReturn().set(0, dataSize - 2, false, null);
        }
        System.err.println("HEADER PENDING: " + (2 - avaliable));
        return this.getHeaderInfoReturn().set(2 - avaliable, 0, false, null);
    }
}

