﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Aqua877.WinApp.IronLivetube
{
	public struct FindConditionsData
	{
		public string Pattern { get; set; }
		public bool IgnoreCase { get; set; }
		public bool IsUseRegex { get; set; }
	}

	public partial class FindWindow : Form
	{
		private FindConditionsData _FindConditions;

		public event Action OnFindConditionsChanged;

		public FindWindow()
		{
			this.InitializeComponent();
		}

		public FindConditionsData FindConditions
		{
			get
			{
				return this._FindConditions;
			}
			set
			{
				this._FindConditions = value;
			}
		}

		private void FindNextButton_Click(object sender, EventArgs e)
		{
			if (this.FindPatternTextBox.Text.Trim() == "")
			{
				this.FindErrorLabel.Visible = true;
				this.FindErrorLabel.Text = "    検索する文字列を入力してください";
				return;
			}
			else
			{
				this._FindConditions.Pattern = this.FindPatternTextBox.Text;
				this.OnFindConditionsChanged();
				this.Close();
			}
		}

		private void IsIgnoreCaseCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			this._FindConditions.IgnoreCase = this.IsIgnoreCaseCheckBox.Checked;
		}

		private void IsFindWithRegularExpressionsCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			this._FindConditions.IsUseRegex = this.IsFindWithRegularExpressionsCheckBox.Checked;
		}
	}
}
