﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.IO;
using System.Xml.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows.Forms;

namespace Aqua877.WinApp.IronLivetube.LSchedule
{
	public static class Settings
	{
		public static SettingObject Setting;
		public static Image LoadingImage;

		public static void Load()
		{
			using (var fs = new FileStream(Environment.CurrentDirectory + "\\Settings.dat", FileMode.OpenOrCreate, FileAccess.Read))
			{
				try
				{
					var deserializer = new BinaryFormatter();
					Setting = deserializer.Deserialize(fs) as SettingObject;

					if (Setting == null)
					{
						Setting = new SettingObject();
					}
				}
				catch
				{
					Setting = new SettingObject();
				}
			}

			LoadingImage = Image.FromFile(Environment.CurrentDirectory + "\\Loading.png");
		}

		public static void Save()
		{
			using (var fs = new FileStream(Environment.CurrentDirectory + "\\Settings.dat", FileMode.Create, FileAccess.Write))
			{
				try
				{
					var serializer = new BinaryFormatter();
					serializer.Serialize(fs, Setting);
				}
				catch (IOException)
				{
					return;
				}
			}

			LoadingImage.Dispose();
		}
	}

	public enum MatchTarget
	{
		Author,
		Title,
		Tags
	}

	[Serializable]
	public class Favorite
	{
		public string FavoriteString { get; set; }
		public MatchTarget Target { get; set; }
		public Color TextColor { get; set; }
		public Color BackgroundColor { get; set; }
	}

	[Serializable]
	public class Filtering
	{
		public string FilteringString { get; set; }
		public MatchTarget Target { get; set; }
	}

	[Serializable]
	public class SettingObject
	{
		public List<Favorite> FavoriteList = new List<Favorite>();
		public List<Filtering> FilteringList = new List<Filtering>();

		public string NotifySoundPath;
		public bool IsNotifyOnPopUp;
		public bool IsLockSort;
		public bool IsStoreTaskTray;
		public View ViewMode = View.Details;
		public string IronLivetubePath;
	}
}
