﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Reflection;

namespace Aqua877.WinApp.IronLivetube.LSchedule
{
	public partial class SettingsWindow : Form
	{
		public SettingsWindow()
		{
			this.InitializeComponent();

			this.NotifySoundPathTextBox.Text = Settings.Setting.NotifySoundPath;
			this.IsNotifyOnPopUpCheckBox.Checked = Settings.Setting.IsNotifyOnPopUp;
			this.IsLockSortCheckBox.Checked = Settings.Setting.IsLockSort;
			this.IsStoreTaskTrayCheckBox.Checked = Settings.Setting.IsStoreTaskTray;
			switch (Settings.Setting.ViewMode)
			{
				case View.Details:
					this.ViewModeBox.Text = "詳細";
					break;

				case View.SmallIcon:
					this.ViewModeBox.Text = "小さなアイコン";
					break;

				case View.LargeIcon:
					this.ViewModeBox.Text = "大きなアイコン";
					break;

				case View.List:
					this.ViewModeBox.Text = "一覧";
					break;

				default: break;
			}
			this.IronLivetubePathTextBox.Text = Settings.Setting.IronLivetubePath;

			this.FavoriteList.Items.AddRange(
				Settings.Setting.FavoriteList
				.Select(xs => String.Format("[{0}] {1}", xs.Target == MatchTarget.Author ? "配信者名" : xs.Target == MatchTarget.Title ? "配信名" : "タグ", xs.FavoriteString)).ToArray());

			this.FilteringList.Items.AddRange(
				Settings.Setting.FilteringList
				.Select(xs => String.Format("[{0}] {1}", xs.Target == MatchTarget.Author ? "配信者名" : xs.Target == MatchTarget.Title ? "配信名" : "タグ", xs.FilteringString)).ToArray());
		}

		//全般設定タブ
		private void ChangeNotifySoundPathButton_Click(object sender, EventArgs e)
		{
			var ret = this.ChangeNotifySoundPathDialog.ShowDialog();

			if (ret == DialogResult.OK)
			{
				Settings.Setting.NotifySoundPath = this.ChangeNotifySoundPathDialog.FileName;
			}
			else if (ret == DialogResult.Cancel)
			{
				Settings.Setting.NotifySoundPath = "";
			}
		}

		private void IsNotifyOnPopUpCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			Settings.Setting.IsNotifyOnPopUp = this.IsNotifyOnPopUpCheckBox.Checked;
		}

		private void IsLockSortCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			Settings.Setting.IsLockSort = this.IsLockSortCheckBox.Checked;
		}

		private void IsStoreTaskTrayCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			Settings.Setting.IsStoreTaskTray = this.IsStoreTaskTrayCheckBox.Checked;
		}

		private void ViewModeBox_SelectedIndexChanged(object sender, EventArgs e)
		{
			switch (this.ViewModeBox.Text)
			{
				case "詳細":
					Settings.Setting.ViewMode = View.Details;
					break;

				case "小さなアイコン":
					Settings.Setting.ViewMode = View.SmallIcon;
					break;

				case "大きなアイコン":
					Settings.Setting.ViewMode = View.LargeIcon;
					break;

				case "一覧":
					Settings.Setting.ViewMode = View.List;
					break;

				default: break;
			}
		}

		private void ChangeIronLivetubePathButton_Click(object sender, EventArgs e)
		{
			var ret = this.ChangeIronLivetubePathDialog.ShowDialog();

			if (ret == DialogResult.OK)
			{
				Settings.Setting.IronLivetubePath = this.ChangeIronLivetubePathDialog.FileName;
			}
			else if (ret == DialogResult.Cancel)
			{
				Settings.Setting.IronLivetubePath = "";
			}
		}

		//通知登録タブ
		private void AddFavoriteButton_Click(object sender, EventArgs e)
		{
			if (this.AddFavoriteTextBox.Text == "")
			{
				return;
			}

			var t = this.AddFavoriteByLiveAuthorButton.Checked ? MatchTarget.Author : this.AddFavoriteByLiveTitleButton.Checked ? MatchTarget.Title : MatchTarget.Tags;

			if (Settings.Setting.FavoriteList.Any(xs => xs.FavoriteString == this.AddFavoriteTextBox.Text && xs.Target == t))
			{
				return;
			}

			this.FavoriteList.Items.Add(
				String.Format("[{0}] {1}",
				this.AddFavoriteByLiveAuthorButton.Checked ? "配信者名" :
				this.AddFavoriteByLiveTitleButton.Checked ? "配信名" : "タグ",
				this.AddFavoriteTextBox.Text
			));

			Settings.Setting.FavoriteList.Add(
				new Favorite()
				{
					FavoriteString = this.AddFavoriteTextBox.Text,
					Target = t,
					TextColor = this.PreviewTextColorTextBox.BackColor,
					BackgroundColor = this.PreviewBackgroundColorTextbox.BackColor
				}
			);

			this.AddFavoriteTextBox.Text = "";
		}

		private void RemoveFavoriteButton_Click(object sender, EventArgs e)
		{
			if (!this.FavoriteList.SelectedItems.Cast<object>().Any())
			{
				return;
			}

			Settings.Setting.FavoriteList.RemoveAt(this.FavoriteList.SelectedIndex);
			this.FavoriteList.Items.Remove(this.FavoriteList.SelectedItems[0]);
		}

		private void ChangeTextColorButton_Click(object sender, EventArgs e)
		{
			var ret = this.TextColorDialog.ShowDialog();

			if (ret == DialogResult.OK)
			{
				this.PreviewTextColorTextBox.BackColor = this.TextColorDialog.Color;
			}
		}

		private void ChangeBackgroundColorButton_Click(object sender, EventArgs e)
		{
			var ret = this.BackgroundColorDialog.ShowDialog();

			if (ret == DialogResult.OK)
			{
				this.PreviewBackgroundColorTextbox.BackColor = this.BackgroundColorDialog.Color;
			}
		}

		private void FavoriteList_DrawItem(object sender, DrawItemEventArgs e)
		{
			if (e.Index > -1)
			{
				var row = this.FavoriteList.Items[e.Index] as string;
				var t = row.Split(' ')[0].Trim('[').TrimEnd(']') == "配信者名" ? MatchTarget.Author : row.Split(' ')[0].Trim('[').TrimEnd(']') == "配信名" ? MatchTarget.Title : MatchTarget.Tags;
				var s = row.Split(' ')[1];
				var d = Settings.Setting.FavoriteList.Single(xs => xs.FavoriteString == s && xs.Target == t);

				Brush textBrush = null;
				Brush backgroundBrush = null;
				if ((e.State & DrawItemState.Selected) != DrawItemState.Selected)
				{
					textBrush = new SolidBrush(d.TextColor);
					backgroundBrush = new SolidBrush(d.BackgroundColor);
				}
				else
				{
					textBrush = new SolidBrush(e.ForeColor);
					backgroundBrush = new SolidBrush(SystemColors.MenuHighlight);
				}

				e.Graphics.FillRectangle(backgroundBrush, ((Rectangle)(typeof(DrawItemEventArgs).GetField("rect", BindingFlags.Instance | BindingFlags.GetField | BindingFlags.NonPublic).GetValue(e))));
				e.Graphics.DrawString(row, e.Font, textBrush, e.Bounds);
			}
			else
			{
				e.DrawBackground();
			}
		}

		//除外登録タブ
		private void AddFilteringButton_Click(object sender, EventArgs e)
		{
			if (this.AddFilteringTextBox.Text == "")
			{
				return;
			}

			var t = this.AddFilteringByLiveAuthorButton.Checked ? MatchTarget.Author : this.AddFilteringByLiveTitleButton.Checked ? MatchTarget.Title : MatchTarget.Tags;

			if (Settings.Setting.FilteringList.Any(xs => xs.FilteringString == this.AddFilteringTextBox.Text && xs.Target == t))
			{
				return;
			}

			this.FilteringList.Items.Add(
				String.Format("[{0}] {1}",
				this.AddFilteringByLiveAuthorButton.Checked ? "配信者名" :
				this.AddFilteringByLiveTitleButton.Checked ? "配信名" : "タグ",
				this.AddFilteringTextBox.Text
			));

			Settings.Setting.FilteringList.Add(
				new Filtering()
				{
					FilteringString = this.AddFilteringTextBox.Text,
					Target = t,
				}
			);

			this.AddFilteringTextBox.Text = "";
		}

		private void RemoveFilteringButton_Click(object sender, EventArgs e)
		{
			if (!this.FilteringList.SelectedItems.Cast<object>().Any())
			{
				return;
			}

			Settings.Setting.FilteringList.RemoveAt(this.FilteringList.SelectedIndex);
			this.FilteringList.Items.Remove(this.FilteringList.SelectedItems[0]);
		}


	}
}
