package views
{
	import mx.core.DPIClassification;
	
	import spark.components.IconItemRenderer;
	
	public class VideoItemRenderer extends IconItemRenderer
	{
		
		private var _link:String = null;
		
		
		public function VideoItemRenderer()
		{
			super();
			
			switch (applicationDPI)
			{
				case DPIClassification.DPI_320:
				{
					iconHeight = 100*2;
					iconWidth = 130*2;
					break;
				}
				case DPIClassification.DPI_240:
				{
					iconHeight = 100;
					iconWidth = 130;	
					break;
				}
				default:
				{
					// default PPI160
					iconHeight = 100/2;
					iconWidth = 130/2;
					break;
				}
			}
			
			iconField = "thumbImg";
			labelField = "title";
			messageField = "thumbInfo";
			
		}

		public function get link():String
		{
			return _link;
		}

		public function set link(value:String):void
		{
			_link = value;
		}

	}
}