/*							*/
/*	D-STAR room client Program               	*/
/*      	    V00.28  12/15/2011                  */
/*  				Satoshi Yasuda		*/
/*				7m3tjz/ad6gz		*/
/*                              	                */


#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <windows.h>
#include <assert.h>
#include <time.h>
#include "usb.h"
#include "node.h"
#include "dstar.h"

#define FALSE   0
#define TRUE    1

#define	IN_PORT		39998	/* default IN UDP port */
#define	OUT_PORT	39999	/* default OUT UDP port */

#define	servername	"ns.jk1zrw.org"

#define AccessCtrl      "callsign.txt"

//#define JitterBufferSize	42		/* 21 ̔{ɂ邱 */
//#define JitterBufferWait	20		/* őlJitterBufferSize@1₷Ƃ20mSec.x܂ */
#define VersionHigh	0x00
#define VersionLow	0x28
#define	VersionYear	0x11
#define	VersionMonth	0x12
#define	VersionDay	0x15

struct	search_table *first_pnt;	
usb_dev_handle *udev;
struct	udp_packet recv_dv, send_dv;

SOCKET	recv_sock, send_sock;
u_long	out_ip, host_ip, from_ip;
char	MyNodeCall[8] = {"********"};
char	RoomName[8] = {"********"};
char	server[128] = {servername};
char	notfoundfile[128];
char	invalidfile[128];
char	audiodir[128];
char	accessctrl[128] = {AccessCtrl};
int	info, debug, PICinfo, RFinfo, Notice, NodeCallCheck, NodeOn, CrcSW;
char	lastframe[6] = {0x55,0x55,0x55,0x55,0xc8,0x7a};
char	LastFrameCheckRx[6];
char	LastFrameCheckTx[6];
char 	buffer[32];
char 	status;
unsigned char slow_data_buf[6];
struct	sockaddr_in from;
struct	sockaddr_in addr_db;
struct	sockaddr_in addr_out;
int 	ret, LastFrameSW;
fd_set	readfd;
int	max_keep_alive = 10;
int	maxPTTkeepalive = 20;
int	PTTkeepalive = 0;
int	JitterBufferSize = 42;
int	JitterBufferWait = 20;
double	HeaderGenTime = 5;
int	PTT_ON;
int	ok;
int	in_port = {IN_PORT};
int	out_port ={OUT_PORT};
char	*cfg_file;

struct	timeval	tv;

WSADATA wsaData;
struct	sockaddr_in addr_in;
struct	hostent *p_ent;
struct	in_addr *p_in_addr;

int	sync;
int	ssn;

//unsigned char JitterBuffer[JitterBufferSize][12];
unsigned char	*JitterBufferAddr;
int	VoicePacketCnt;
int	JitterBufferPnt;
int	VoicePacketSW;
int	RepeaterOn;
int	SendSW;
int	HeaderRead;
int	voice_pnt;
int	seq;

int	seq_no;

struct	usb_device *dev;
time_t	time1, time2;
int	header_gen;

void	delete_node_db (struct sockaddr_in addr, char DeleteCallSign[]);


void main(int argc, const char **argv) {
	struct	usb_bus *bus;
	int 	dev_found;
	int	i,k;


	unsigned char	ssn_temp[2];

	signal (SIGINT, ctrl_c);
	signal (SIGBREAK, ctrl_c);

	print_version();

	info = FALSE;
	debug = FALSE;
	PICinfo = FALSE;
	RFinfo = FALSE;
	Notice = FALSE;
	NodeCallCheck = FALSE;
	NodeOn = TRUE;
	CrcSW = TRUE;
	cfg_file = NULL;
	first_pnt = NULL;
	send_dv.udp_p.b_bone.seq_low = 0xff;
	sync = 0;
	PTT_ON = FALSE;
	RepeaterOn = FALSE;
	SendSW = FALSE;
	HeaderRead = FALSE;
	voice_pnt = 0;
	header_gen = FALSE;

	/* High priority set (ABOVE NORMAL) */
	SetPriorityClass(GetCurrentProcess, THREAD_PRIORITY_ABOVE_NORMAL);

	if (argc >= 2) option_set (argc, (char **)argv);

	if (debug) printf ("                      debug mode\n");
	cfg_read(cfg_file);

	JitterBufferAddr = malloc (JitterBufferSize * 12);
	if (JitterBufferAddr == NULL)
	{
		printf ("Error enough memory for Jitter Buffer (%d)\n",JitterBufferSize * 12);
		return;
	}

	usb_init();
	usb_find_busses();
	usb_find_devices();

	udev = NULL;
	dev_found = FALSE;
	for (bus = usb_get_busses(); bus && !dev_found; bus = bus->next) {
        	for (dev = bus->devices; dev && !dev_found; dev = dev->next) {
            	  if ((dev->descriptor.idVendor == 0x04D8) && (dev->descriptor.idProduct == 0x0300))
		  {
                	dev_found = TRUE;
                	udev = usb_open(dev);
			break;
            	  }
        	}
	}

	if (!dev_found) {
		printf("\nPlease check the USB Cable! or Node Adapter!\n");
		return;
	}

	usb_set_configuration (udev, 1);

	Inet_SetUp();

	if (PICinfo) print_PICinfo();

	time1 = 0;

	LastFrameSW = 0;	
	memset(&send_dv, 0, 56);
	strncpy (send_dv.udp_p.id,"DVND",4);

	JitterBufferInit();

	from_ip = 0;
	printf ("START TIME %.24s\n",curtime());
	

/*		*/
/*    loop 	*/
/*		*/

	while (1)
	{
		tv.tv_sec = 0;
		tv.tv_usec = 10000;		/* 10 m Sec. */

		read_from_inet (tv);		/* read from inet (udp packet) */
		read_from_rig ();		/* read from rig (DV packket) */

		if (VoicePacketSW && VoicePacketCnt) JitterBufferSend();

	}	/* end while (1) */
}

void	option_set (int argc, char **argv)
{
	int	i;

	for (i = 1 ; i < argc ; i++)
	{
		if (!strncmp (argv[i],"-d",2)) 	debug = TRUE;
		else if (!strncmp (argv[i], "-i",2)) info = TRUE;
		else if (!strncmp (argv[i], "-p",2)) PICinfo = TRUE;
		else if (!strncmp (argv[i], "-r",2)) RFinfo = TRUE;
		else if (!strncmp (argv[i], "-n",2)) Notice = TRUE;
		else if (!strncmp (argv[i], "-f",2)) cfg_file = (char *)argv[i+1];
		else if (!strncmp (argv[i], "-?",2)) usage();
	}
}

void	read_from_rig()		/* read from rig (DV packet) */
{
	int	i, r;
	unsigned char ssn_temp[2];

	/***  from RIG  ***/

	if (!HeaderRead)
	{

	        ret = usb_control_msg(udev, 0xC0, GET_HEADER, 0, 0, send_dv.udp_p.dv_buff.buff, 32, 100);
		if (ret == 0) return;
		if (ret < 0) 
		{
			printf ("%.19s GET_HEADER ERROR ret: %d\n",curtime(), ret);
			delete_node_db (addr_db, MyNodeCall);
			usb_close(udev);
			shutdown (recv_sock, SD_RECEIVE);
			shutdown (send_sock, SD_SEND);
			closesocket(recv_sock);
			closesocket(send_sock);
			WSACleanup();
			printf ("\nEND TIME %s\n",curtime());
			abort();
		}


	       	r = usb_control_msg(udev, 0xC0, GET_HEADER, 0, 0, &send_dv.udp_p.dv_buff.buff[32], 9, 100);
		if (r < 0) printf ("%.19s GET_HEADER 2 ret: %d\n",curtime, r);

		r = usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &status, 1, 100);
		if (r < 0) printf ("%.19s GET_AD_STATUS(GET_HEADER) ret: %d\n",curtime, r);
		if ((status & CRC_ERROR) & CrcSW) return;
		if (status & HeaderGen)
		{
			time (&time2);

			if (debug) printf ("\n%.19s HeaderGen %.0f(%.0f)\n",curtime(),difftime (time2, time1), HeaderGenTime);
			if (difftime (time2, time1) > HeaderGenTime)
			{
				header_gen = FALSE;
				if (debug) printf ("Skip Generation header\n");
				return;
			}
			header_gen = TRUE;
		}

		if (!callsign_check (send_dv.udp_p.rf_header.MyCall)) return;

		if (Notice) printf ("%.19s RF to Inet %0.8s\n",curtime(), send_dv.udp_p.rf_header.YourCall);

		r = usb_control_msg(udev, 0xC0, GET_SN_VALUE, 0, 0, ssn_temp, 2, 100);
		if (r < 0) printf ("%.19s GET_SN_VALUE ret: %d\n",curtime, r);
		ssn = ssn_temp[0] * 4 + (ssn_temp[1] >> 6);
	
		if (!strncmp (send_dv.udp_p.rf_header.YourCall, "********",8)) return;

		send_dv.udp_p.b_bone.id = 0x20;
		send_dv.udp_p.b_bone.dest_repeater_id = 0x20;
		send_dv.udp_p.b_bone.send_repeater_id = MyNodeCall[7];
		send_dv.udp_p.b_bone.send_terminal_id = send_dv.udp_p.rf_header.MyCall[7];

		if (NodeCallCheck)
		{
			if (!strncmp(send_dv.udp_p.rf_header.RPT1Call, MyNodeCall, 8)) NodeOn = TRUE;
			else NodeOn = FALSE;
		} else {
			NodeOn = TRUE;
		}

		if (!NodeOn) return;

		update_self_node_db (addr_db);				

		addr_out.sin_family = AF_INET;
		addr_out.sin_addr.s_addr = out_ip = host_ip;

		if (debug || info || RFinfo) header_print (send_dv, out_ip, 1);
		addr_out.sin_port = htons(out_port);
		send_dv.udp_p.b_bone.seq_high = 0;
		send_dv.udp_p.b_bone.seq_low = 0;
		send_dv.udp_p.b_bone.id = header_type;
		if (sendto(send_sock, (char *)&send_dv, 56, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
		{
			printf("send error 1:%d %x\n",WSAGetLastError(),out_ip);
			while (WSAGetLastError() == WSAENOBUFS)
			{
				Sleep (50);
				addr_out.sin_family = AF_INET;
				addr_out.sin_port = htons(out_port);
				addr_out.sin_addr.s_addr = out_ip;
				sendto(send_sock, (char *)&send_dv, 56, 0, (struct sockaddr *)&addr_out, sizeof(addr_out));
			}
		}
		HeaderRead = TRUE;
		seq = 0;
		voice_pnt = 0;
	} else {
	
       		ret = usb_control_msg(udev, 0xC0, GET_DATA, 0, 0, buffer, 32, 100);
		if (ret < 0) printf ("%.19s GET_DATA ERROR ret: %d\n",curtime, ret);
		if (debug && (ret < 0)) printf ("%.19s GET_DATA ret: %d\n",curtime(),ret);
		if (ret > 0)
		{
			if (!header_gen) time (&time1);
			for (i = 0 ; i < ret; i++)
			{
				send_dv.udp_p.dv_buff.buff[voice_pnt] = buffer[i];
				voice_pnt++;
				LastFrameCheckRx[0] = LastFrameCheckRx[1];
				LastFrameCheckRx[1] = LastFrameCheckRx[2];
				LastFrameCheckRx[2] = LastFrameCheckRx[3];
				LastFrameCheckRx[3] = LastFrameCheckRx[4];
				LastFrameCheckRx[4] = LastFrameCheckRx[5];
				LastFrameCheckRx[5] = buffer[i];
				if (!strncmp(LastFrameCheckRx, lastframe, 6))
				{
					if (debug) voice_packet_print (send_dv, out_ip, 1, seq);
					addr_out.sin_family = AF_INET;
					addr_out.sin_port = htons(out_port);
					addr_out.sin_addr.s_addr = out_ip;
					send_dv.udp_p.b_bone.seq_high = seq >> 8;
					send_dv.udp_p.b_bone.seq_low = seq & 0xff;
					send_dv.udp_p.b_bone.id = dv_type;
					if (sendto(send_sock, (char *)&send_dv, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
					{
						printf("send error 2:%d %x\n",WSAGetLastError(),out_ip);
						while (WSAGetLastError() == WSAENOBUFS)
						{
							Sleep (50);
							addr_out.sin_family = AF_INET;
							addr_out.sin_port = htons(out_port);
							addr_out.sin_addr.s_addr = out_ip;
							sendto(send_sock, (char *)&send_dv, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out));
						}
					}
					HeaderRead = FALSE;
					header_gen = FALSE;
					return;
				}
			
				if (voice_pnt == 12)
				{
					voice_pnt = 0;
					if (debug) voice_packet_print (send_dv, out_ip, 1, seq);
					addr_out.sin_family = AF_INET;
					addr_out.sin_port = htons(out_port);
					addr_out.sin_addr.s_addr = out_ip;
					send_dv.udp_p.b_bone.seq_high = seq >> 8;
					send_dv.udp_p.b_bone.seq_low = seq & 0xff;
					send_dv.udp_p.b_bone.id = dv_type;
					if (sendto(send_sock, (char *)&send_dv, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out)) == SOCKET_ERROR)
					{
						printf("send error 2:%d %x\n",WSAGetLastError(),out_ip);
						while (WSAGetLastError() == WSAENOBUFS)
						{
							Sleep (50);
							addr_out.sin_family = AF_INET;
							addr_out.sin_port = htons(out_port);
							addr_out.sin_addr.s_addr = out_ip;
							sendto(send_sock, (char *)&send_dv, 27, 0, (struct sockaddr *)&addr_out, sizeof(addr_out));
						}
					}
					++seq;
					if (seq >= 2100) seq = 0;  /* 2 sec. */							
				}
			}
		} else if (ret == 0)
		{
	       		r = usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &status, 1, 100);
			if (r < 0) printf ("%.19s GET_AD_STATUS ret: %d\n",curtime, r);
			if (!(status & COS_OnOff))
			{
				HeaderRead = FALSE;
				header_gen = FALSE;
				return;
			}
		}
       		r = usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &status, 1, 100);
		if (r < 0) printf ("%.19s GET_AD_STATUS ret: %d\n",curtime, r);
		if (status & HeaderDecodeDone)
		{
			HeaderRead = FALSE;
			header_gen = FALSE;
			return;
		}
	}
}

void	add_self_node_db (struct sockaddr_in addr)
{
 /*  T[o[ɓo^@*/  
	struct	call_table db_m, recv_m;
	int	fromlen;
	int	leng;

	strncpy (db_m.zone, RoomName, 8);
	strncpy (db_m.area, MyNodeCall, 8);
	strncpy (db_m.req_callsign, MyNodeCall, 8);
	db_m.ip_address = 0;
	strncpy (db_m.req_id, "SI", 2);
	db_m.flags[0] = VersionHigh;
	db_m.flags[1] = VersionLow;
	db_m.ssn = 0;
	db_m.port = in_port;
	db_m.PicVer[0] = dev->descriptor.bcdDevice >> 8;
	db_m.PicVer[1] = dev->descriptor.bcdDevice & 0xff;
	if (RepeaterOn) db_m.flag.RepeaterAcc = 1;
	else		db_m.flag.RepeaterAcc = 0;
		
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(out_port);
	addr.sin_addr.s_addr = host_ip;

	if (sendto(send_sock, (char *)&db_m, sizeof(struct call_table), 0, (struct sockaddr *)&addr, sizeof(addr)) == SOCKET_ERROR)
	{
		printf("add_self_node_db error:%d\n",WSAGetLastError());
		while (WSAGetLastError() == WSAENOBUFS)
		{
			Sleep (50);
			addr.sin_family = AF_INET;
			addr.sin_port = htons(out_port);
			addr.sin_addr.s_addr = host_ip;
			sendto(send_sock, (char *)&db_m, sizeof(struct call_table), 0, (struct sockaddr *)&addr, sizeof(addr));
		}
	}
	fromlen = sizeof (struct sockaddr);

/*@@T[o[̉҂
    @PObԉȂ΁AT[o[_EĂƂď@
 */
	tv.tv_sec = 10;
	tv.tv_usec = 0;
	FD_ZERO (&readfd);
	FD_SET (recv_sock, &readfd);
	ret = select(FD_SETSIZE, &readfd, NULL, NULL, &tv );
	if (ret)
	{
		if (FD_ISSET(recv_sock, &readfd)) {
			leng = recvfrom (recv_sock, (char *)&recv_m, 16, 0, (struct sockaddr *)&from, &fromlen);
			if (debug) printf ("\n*** length: %d from INET\n",leng);
			if (!strncmp(recv_m.req_id,"SA",2))
			{
				FD_CLR (recv_sock, &readfd);	
				return;
			}
		}
	}
	FD_CLR (recv_sock, &readfd);
	usb_control_msg(udev, 0x40, SET_AD_RESET, ON, 0, buffer, 0, 100);	/* reset Node Adapter */
	usb_close(udev);
	closesocket(recv_sock);
	closesocket(send_sock);
	WSACleanup();
	printf ("Server Down!\n");
	printf ("\nEND TIME %s\n",curtime());
	abort ();
}

void	update_self_node_db (struct sockaddr_in addr)
{
	struct	call_table db_m;

	strncpy (db_m.zone, RoomName, 8);
	strncpy (db_m.area, MyNodeCall, 8);
	strncpy (db_m.req_callsign, MyNodeCall, 8);
	db_m.ip_address = 0;
	strncpy (db_m.req_id, "RS", 2);
	db_m.flags[0] = VersionHigh;
	db_m.flags[1] = VersionLow;
	db_m.ssn = ssn;
	db_m.port = in_port;
	db_m.PicVer[0] = dev->descriptor.bcdDevice >> 8;
	db_m.PicVer[1] = dev->descriptor.bcdDevice & 0xff;

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(out_port);
	addr.sin_addr.s_addr = host_ip;
	if (sendto(send_sock, (char *)&db_m, sizeof(struct call_table), 0, (struct sockaddr *)&addr, sizeof(addr)) 
			== SOCKET_ERROR)
	{
		printf("update_self_node_db error:%d\n",WSAGetLastError());
		while (WSAGetLastError() == WSAENOBUFS)
		{
			Sleep (50);
			addr.sin_family = AF_INET;
			addr.sin_port = htons(out_port);
			addr.sin_addr.s_addr = host_ip;
			sendto(send_sock, (char *)&db_m, sizeof(struct call_table), 0, (struct sockaddr *)&addr, sizeof(addr));
		}
	}
	
	return;
}

void	delete_node_db (struct sockaddr_in addr, char DeleteCallSign[])
{
	struct	call_table db_m;

	strncpy (db_m.req_callsign, DeleteCallSign, 8);
	strncpy (db_m.req_id, "DD", 2);
	db_m.flags[0] = VersionHigh;
	db_m.flags[1] = VersionLow;
	db_m.PicVer[0] = dev->descriptor.bcdDevice >> 8;
	db_m.PicVer[1] = dev->descriptor.bcdDevice & 0xff;

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(out_port);
	addr.sin_addr.s_addr = host_ip;
	if (sendto(send_sock, (char *)&db_m, 16, 0, (struct sockaddr *)&addr, sizeof(addr)) == SOCKET_ERROR)
	{
		printf("delete_node_db error:%d\n",WSAGetLastError());
		while (WSAGetLastError() == WSAENOBUFS)
		{
			Sleep (50);
			addr.sin_family = AF_INET;
			addr.sin_port = htons(out_port);
			addr.sin_addr.s_addr = host_ip;
			sendto(send_sock, (char *)&db_m, 16, 0, (struct sockaddr *)&addr, sizeof(addr));
		}
	}
}

void	alive_node_db (struct sockaddr_in addr, char AliveCallSign[])
{
	struct	call_table db_m;

	strncpy (db_m.req_callsign, AliveCallSign, 8);
	strncpy (db_m.req_id, "AL", 2);
	db_m.flags[0] = VersionHigh;
	db_m.flags[1] = VersionLow;
	db_m.PicVer[0] = dev->descriptor.bcdDevice >> 8;
	db_m.PicVer[1] = dev->descriptor.bcdDevice & 0xff;

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(out_port);
	addr.sin_addr.s_addr = host_ip;
	if (sendto(send_sock, (char *)&db_m, 16, 0, (struct sockaddr *)&addr, sizeof(addr)) == SOCKET_ERROR)
	{
		printf("alive_node_db error:%d\n",WSAGetLastError());
		while (WSAGetLastError() == WSAENOBUFS)
		{
			Sleep (50);
			addr.sin_family = AF_INET;
			addr.sin_port = htons(out_port);
			addr.sin_addr.s_addr = host_ip;
			sendto(send_sock, (char *)&db_m, 16, 0, (struct sockaddr *)&addr, sizeof(addr));
		}
	}
}


void	ctrl_c ()
{
	struct search_table *p, *next;
	char	string[10];
	int	i;

	delete_node_db (addr_db, MyNodeCall);
	Sleep (500);
	usb_control_msg(udev, 0x40, SET_AD_RESET, ON, 0, buffer, 0, 100);	/* reset Node Adapter */
	usb_close(udev);
	shutdown (recv_sock, SD_RECEIVE);
	shutdown (send_sock, SD_SEND);
	closesocket(recv_sock);
	closesocket(send_sock);
	WSACleanup();
	printf ("\nEND TIME %s\n",curtime());
	abort();
}

char *curtime(void)
{
	struct tm *pt;
	time_t	t;

	time (&t);
	pt = localtime (&t);
	return asctime(pt);
}

void	header_print (struct udp_packet r_dv, u_long ip, int sw)
{
	printf ("%.24s\n",curtime());
	if (sw)
	{
		printf ("Header to %3.3d.%3.3d.%3.3d.%3.3d   ",
				ip & 0xff,
				(ip >>  8) & 0xff,
				(ip >> 16) & 0xff,
				ip >> 24);
	} else {
		printf ("Header from %3.3d.%3.3d.%3.3d.%3.3d   ",
				ip & 0xff,
				(ip >>  8) & 0xff,
				(ip >> 16) & 0xff,
				ip >> 24);
	}
	printf ("Flags: %2.2x %2.2x %2.2x\n",r_dv.udp_p.rf_header.flags[0],
						r_dv.udp_p.rf_header.flags[1],
						r_dv.udp_p.rf_header.flags[2]); 
	if (strncmp((char *)&r_dv.udp_p.rf_header.MyCall2,"    ",4))
	{
		printf ("MyCall: %.8s/%.4s  ",r_dv.udp_p.rf_header.MyCall,r_dv.udp_p.rf_header.MyCall2);
	} else { 
		printf ("MyCall: %.8s       ",r_dv.udp_p.rf_header.MyCall);
	}
	printf ("YourCall: %.8s   ",r_dv.udp_p.rf_header.YourCall); 
	printf ("RPT1: %.8s   ",r_dv.udp_p.rf_header.RPT1Call); 
	printf ("RPT2: %.8s\n",r_dv.udp_p.rf_header.RPT2Call); 
	return;
}

void	voice_packet_print (struct udp_packet r_dv, u_long ip, int sw, int seq_n)
{
	printf ("%.19s ",curtime());
	if (sw)
	{
		printf ("to %3.3d.%3.3d.%3.3d.%3.3d  ",
				ip & 0xff,
				(ip >>  8) & 0xff,
				(ip >> 16) & 0xff,
				ip >> 24);
	} else {
		printf ("from %3.3d.%3.3d.%3.3d.%3.3d  ",
				ip & 0xff,
				(ip >>  8) & 0xff,
				(ip >> 16) & 0xff,
				ip >> 24);
	}
	printf ("%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
				r_dv.udp_p.dv_buff.buff[0],				 
				r_dv.udp_p.dv_buff.buff[1],				 
				r_dv.udp_p.dv_buff.buff[2],				 
				r_dv.udp_p.dv_buff.buff[3],				 
				r_dv.udp_p.dv_buff.buff[4],				 
				r_dv.udp_p.dv_buff.buff[5],				 
				r_dv.udp_p.dv_buff.buff[6],				 
				r_dv.udp_p.dv_buff.buff[7],				 
				r_dv.udp_p.dv_buff.buff[8]);				 
	if (seq_n%21) printf ("  %2.2x %2.2x %2.2x\n",
				r_dv.udp_p.dv_buff.buff[9],				 
				r_dv.udp_p.dv_buff.buff[10],				 
				r_dv.udp_p.dv_buff.buff[11]);
		else printf ("  %2.2x %2.2x %2.2x*\n",
				r_dv.udp_p.dv_buff.buff[9],				 
				r_dv.udp_p.dv_buff.buff[10],				 
				r_dv.udp_p.dv_buff.buff[11]);
	return;
}


void	read_from_inet (struct timeval tv)	/* read from inet (UDP packet) */
{
	int	fromlen;
	int	leng;
	int	ret;
	int	seq;
	int	l;

	if (VoicePacketCnt < JitterBufferSize)
	{ 
		fromlen = sizeof (struct sockaddr);
	
		FD_ZERO (&readfd);
		FD_SET (recv_sock, &readfd);
		ret = select(FD_SETSIZE, &readfd, NULL, NULL, &tv );
		if (ret)
		{
		if (FD_ISSET(recv_sock, &readfd)) {
			leng = recvfrom (recv_sock, (char *)&recv_dv, 56, 0, (struct sockaddr *)&from, &fromlen);
			from_ip = from.sin_addr.s_addr;	
			if (debug) printf ("\n*** length %d from INET\n",leng);			

			if (leng == 56)					/* RF header infomation */
			{
				alive_node_db (addr_db, MyNodeCall);
				if (Notice) printf ("%.19s Inet to RF %0.8s\n",curtime(), recv_dv.udp_p.rf_header.YourCall);
				if (RepeaterOn)		/* If connect the repeater with RF, check the DUP flag */
				{
					if (!(recv_dv.udp_p.rf_header.flags[0] & 0x40))
					{
						if (Notice || debug) printf ("TX skip");
						FD_CLR (recv_sock, &readfd);
						SendSW = FALSE;
						seq_no = 0;	
						return;
					}				
				}
				SendSW = TRUE;
				/* Callsign set */
				usb_control_msg(udev, 0x40, SET_MyCALL, 0, 0, recv_dv.udp_p.rf_header.MyCall, 8, 100);
		        	usb_control_msg(udev, 0x40, SET_MyCALL2, 0, 0, recv_dv.udp_p.rf_header.MyCall2, 4, 100);
      				usb_control_msg(udev, 0x40, SET_YourCALL, 0, 0, recv_dv.udp_p.rf_header.YourCall, 8, 100);
   	   			usb_control_msg(udev, 0x40, SET_RPT1CALL, 0, 0, recv_dv.udp_p.rf_header.RPT1Call, 8, 100);
       				usb_control_msg(udev, 0x40, SET_RPT2CALL, 0, 0, recv_dv.udp_p.rf_header.RPT2Call, 8, 100);
			        usb_control_msg(udev, 0x40, SET_FLAGS, 0, 0, recv_dv.udp_p.rf_header.flags, 3, 100);
				if (debug || info) header_print (recv_dv, from_ip, 0);  
				VoicePacketCnt = 0;
				VoicePacketSW = FALSE;
				JitterBufferPnt = 0;
				PTT_ON = FALSE;

			} else if (leng == 27) {			/* voice packet */
				if (debug) voice_packet_print (recv_dv, from_ip, 0, seq_no);
				if (!SendSW)
				{
					if(debug) printf ("TX skip %d(%d)", seq_no, seq_no%21);
					seq_no++;
					if (seq_no >= 2100) seq_no = 0;
					FD_CLR (recv_sock, &readfd);
					return;
				}				
				seq = recv_dv.udp_p.b_bone.seq_high * 256 + recv_dv.udp_p.b_bone.seq_low;
				JitterBufferSave (recv_dv.udp_p.dv_buff.buff, seq);
				for (l = 0; l < 12 ; l++)
				{
					LastFrameCheckTx[0] = LastFrameCheckTx[1]; 
					LastFrameCheckTx[1] = LastFrameCheckTx[2]; 
					LastFrameCheckTx[2] = LastFrameCheckTx[3]; 
					LastFrameCheckTx[3] = LastFrameCheckTx[4]; 
					LastFrameCheckTx[4] = LastFrameCheckTx[5];
					LastFrameCheckTx[5] = recv_dv.udp_p.voice_d.voice_segment[l];
 					if (!strncmp(LastFrameCheckTx,lastframe,6))
					{
						VoicePacketSW = TRUE;
						while (VoicePacketCnt) JitterBufferSend ();
						VoicePacketCnt = 0;
						JitterBufferPnt = 0;
						/* PTT OFF */
						usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, buffer, 0, 100);
						PTT_ON = FALSE;
						VoicePacketSW = FALSE;
					}
				}
			} else {
				printf ("Last Error %d\n",WSAGetLastError());	
			}
		} else {
			PTTkeepalive++;
			if (debug) printf ("\n*** PTTkeepalive %d\n",PTTkeepalive);
			if (PTTkeepalive >= maxPTTkeepalive)
			{
				VoicePacketSW = TRUE;
				while (VoicePacketCnt) JitterBufferSend ();
				VoicePacketCnt = 0;
				JitterBufferPnt = 0;
				/* PTT OFF */
				usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, buffer, 0, 100);
				PTT_ON = FALSE;
			}
		}
		}
		FD_CLR (recv_sock, &readfd);	
  	}
	if (VoicePacketSW && VoicePacketCnt) JitterBufferSend ();

	return;
}


void	cfg_read(char FileName[])	/* read config. file */
{
	FILE	*cfg;
	char	buf[256],str[256];
	char	*token, *last;
	u_int	i;

	cfg = NULL;
	if (FileName != NULL)
	{
		cfg = fopen (FileName,"r");
		if (debug) printf ("\n*** Debug config file name : %s\n",FileName);
	}
	if (cfg == NULL)
	{
		cfg = fopen ("room_client.cfg","r");
		if (cfg == NULL)
		{
			printf ("CONFIG FILE NOT FOUND : %s\n",FileName);
			return;
		}
	}
	
	if (debug) printf ("\n*** Debug on Config File\n");
      
	while (fgets(buf, 256, cfg))
	{
		strcpy (str,buf);
		if (str[strlen(str)-1] == 0x0a) str[strlen(str)-1] = 0x00;
		token = str;
		for (i = 0 ; i < strlen(str) ; i++)
		{
			*token = toupper (*token);
			token++;
		}
		last = strpbrk (str,";");
		if (last == NULL)
		{
			printf ("CONFIG FILE ERROR : %s\n",buf);
		} else {
			*last = 0x00;
			token = str;
			while (*token == 0x20) token++;
			if (!strncmp (token,"ROOMNAME",8))
			{
				token = strpbrk(token,"\"");
				token++;
				last = strpbrk (token,"\"");
				if (last == NULL)
				{
					printf ("CONFIG FILE ERROR : %s\n",buf);
				} else {
					*last = 0x00;
					memset (RoomName, 0x20, 8);
					strncpy (RoomName,token, strlen(token));
					if (debug) printf ("RoomName : %.8s\n",RoomName);
				}
			} else if (!strncmp (token,"MYNODECALLSIGN",14))
			{
				token = strpbrk(token,"\"");
				token++;
				last = strpbrk (token,"\"");
				if (last == NULL)
				{
					printf ("CONFIG FILE ERROR : %s\n",buf);
				} else {
					*last = 0x00;
					memset (MyNodeCall, 0x20, 8);
					strncpy (MyNodeCall,token, strlen(token));
					if (debug) printf ("MyNodeCallSign : %.8s\n",MyNodeCall);
				}
			} else if (!strncmp (token, "NODECALLCHECK", 13))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				if (!strncmp (token, "ON", 2))
				{
					NodeCallCheck = TRUE;
					NodeOn = FALSE;
				}
				if (debug) printf ("NodeCallCheck : %s\n",token);
			} else if (!strncmp (token, "SERVERNAME", 10))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				strcpy (server, token);
				if (debug) printf ("ServerName : %s\n",server);
			} else if (!strncmp (token, "MAXKEEPALIVE", 12))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				max_keep_alive = atoi(token);
				if (debug) printf ("MaxKeepAlive : %d\n",max_keep_alive);
			} else if (!strncmp (token, "MAXPTTKEEPALIVE", 15))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				maxPTTkeepalive = atoi(token);
				if (debug) printf ("MaxPTTKeepAlive : %d\n",maxPTTkeepalive);
				maxPTTkeepalive = maxPTTkeepalive / 10;
			} else if (!strncmp (token, "INPORT", 6))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				in_port = atoi(token);
				if (debug) printf ("InPort : %d\n",in_port);
			} else if (!strncmp (token, "OUTPORT", 7))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				out_port = atoi(token);
				if (debug) printf ("OutPort : %d\n",out_port);
			} else if (!strncmp (token, "CRCCHECK", 8))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				if (!strncmp (token, "ON", 2))
				{
					CrcSW = TRUE;
				}
				if (debug) printf ("CRCcheck : %s\n",token);
			} else if (!strncmp (token, "ACCESSCONTROL", 13))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				strcpy (accessctrl, token);
				if (debug) printf ("AccessControl : %s\n",accessctrl);
			} else if (!strncmp (token, "JITTERBUFFERWAIT", 16))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				JitterBufferWait = atoi(token);
				if (debug) printf ("JitterBufferWait : %d\n",JitterBufferWait);
			} else if (!strncmp (token, "JITTERBUFFERSIZE", 16))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				JitterBufferSize = atoi(token);
				if (!((JitterBufferSize == 21)
					|| (JitterBufferSize == 42)		/* 21 * 2 */
					|| (JitterBufferSize == 84)		/* 21 * 4 */
					|| (JitterBufferSize == 105)		/* 21 * 5 */
					|| (JitterBufferSize == 210)		/* 21 * 10 */
					|| (JitterBufferSize == 420)		/* 21 * 20 */
					|| (JitterBufferSize == 525)		/* 21 * 25 */
					|| (JitterBufferSize == 1050)		/* 21 * 50 */
					|| (JitterBufferSize == 2100)))		/* 21 * 100 */
					{
						printf (" Invalid JitterBufferSize: %d\n",JitterBufferSize);
						JitterBufferSize = 42;
					} 
					if (debug) printf ("JitterBufferSize : %d\n",JitterBufferSize);
			} else if (!strncmp (token, "REPEATER", 8))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				if (!strncmp (token, "YES", 3))
				{
					RepeaterOn = TRUE;
				} else {
					RepeaterOn = FALSE;
				}
				if (debug) printf ("Repeater : %s\n",token);
			} else if (!strncmp (token, "HEADERGENTIME", 13))
			{
				token = strpbrk(token,"=");
				token++;
				while (*token == 0x20) token++;
				HeaderGenTime = atoi(token);
				if (debug) printf ("HeaderGenTime : %d\n",HeaderGenTime);
			} else {
				printf ("CONFIG FILE ERROR : %s\n\n",buf);
			}
		} 			
	}
	fclose (cfg);
	if (debug) printf ("*** Debug Exit\n\n"); 
	return;
}

void	JitterBufferInit()
{
	unsigned char *ptr;
	int	i;
	char 	NullVoice0[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16};
	char 	NullVoice1[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5};

	ptr = JitterBufferAddr;

	if (debug) printf ("Jitter Buffer Initialized\n");

	for (i = 0 ; i < JitterBufferSize ; i++)
	{
		if (i%21 == 0)
		{
			strncpy (ptr + i * 12, NullVoice0, 12);
		} else {
			strncpy (ptr + i * 12, NullVoice1, 12);
		}
	}
	JitterBufferPnt = 0;
	VoicePacketCnt = 0;
	PTT_ON = FALSE;
	return;
}

void	JitterBufferSave (char VoicePacket[], int seq)
{
	unsigned char *ptr;

	ptr = JitterBufferAddr;

	if (debug) printf ("Jitter Buffer Save seq : %d(%d)  Packet Counter : %d\n", seq, seq%21, VoicePacketCnt);
	strncpy (ptr +(seq%JitterBufferSize) * 12, VoicePacket, 12);
	VoicePacketCnt++;
	if (VoicePacketCnt > JitterBufferWait) VoicePacketSW = TRUE;
	return;
}

void	JitterBufferSend ()
{
	int	ret;
	unsigned char	len;
	unsigned char *prt;
	int	timeout_wait;
	char	dummy;

	if (!PTT_ON)
	{
		if (HeaderRead)
		{
			JitterBufferPnt = 0;
			VoicePacketCnt = 0;
			SendSW = FALSE;
			return;
		}
		while (1)
		{
			ret = usb_control_msg(udev, 0xC0, GET_REMAINSPACE, 0, 0, &len , 1, 100);
			if (ret < 0) printf ("%.19s GET_REMAINSPACE ret: %d\n",curtime, ret);
			if (len >= 95)
			{
				timeout_wait = 0;
				/* Check COS */
				ret = usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &status, 1, 100);
				if (ret < 0) printf ("%.19s GET_AD_STATUS(JUtterBufferSend) ret: %d\n",curtime, ret);
				while (status & COS_OnOff)		/* until COS OFF */
				{
					Sleep (200);
					usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &status, 1, 100);
					timeout_wait += 1;
					if (timeout_wait > 10) break;		/* wait 2 seconds */
				}
				/* PTT ON */
				ret = usb_control_msg(udev, 0x40, SET_PTT, ON, 0, &dummy, 0, 100);
				if (ret < 0) printf ("%.19s SET_PTT(ON) ret: %d\n",curtime, ret);
				PTT_ON = TRUE;
				Sleep (100);
				break;
			} else {
				Sleep (200);
			}
		}
	}

	prt = JitterBufferAddr;


	while (1)
	{
		ret = usb_control_msg(udev, 0xC0, GET_REMAINSPACE, 0, 0, &len , 1, 100);
		if (ret < 0) printf ("%.19s GET_REMAINSPACE ret: %d\n",curtime, ret);
		if (len >= 12)
		{
	   	   	ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, prt + JitterBufferPnt * 12, 12, 100);
			if (debug) printf ("Jitter Buffer send ret : %d  Voice packet count : %d  Jitter Buffer point : %d\n",
						ret, VoicePacketCnt, JitterBufferPnt);
			VoicePacketCnt--;
			JitterBufferPnt++;
			if (JitterBufferPnt >= JitterBufferSize) JitterBufferPnt = 0;
			return;
		} else {
			Sleep (50);
		}
	}
}


void	usage()
{
	printf ("Usage:\n\n");
	printf ("node [-?] [-d] [-i] [-f configfile]\n\n");
	printf ("-?  This Message\n");
	printf ("-d  Debug mode\n");
	printf ("-i  Information mode\n");
	printf ("-n  Notice\n");
	printf ("-p  PIC version info.\n");
	printf ("-r  RF Header info.\n");
	printf ("-f configfile configfle name \n");
	exit(0);
}

/* Version and Copyright info. */
void	print_version(void)
{
	printf ("D-STAR room client program V%2.2x.%2.2x 20%2.2x/%2.2x/%2.2x\n",
					VersionHigh, VersionLow, VersionYear, VersionMonth, VersionDay);
	printf (" (C) Satoshi Yasuda 7m3tjz/ad6gz\n");
	return;
}

void	print_PICinfo()
{
	/* PIC VERSION READ */
	int	ret;
	int	i, k;

	printf ("PIC version: ");
	ret = 8;
	while (ret == 8)
	{
       		ret = usb_control_msg(udev, 0xC0, GET_VERSION, 0, 0, buffer, 8, 100);
		if (debug) printf ("\n* Debug GET_VERSION %d * \n",ret);
		for (i = 0 ; i < ret ; i++)
		{
			printf ("%c",buffer[i]);
		} 	
	}
	printf ("\n");
	      	ret = usb_control_msg(udev, 0xC0, GET_USERID, 0, 0, buffer, 8, 100);
	if (ret == 8)
	{
		buffer[8] = 0x20;
		for (i = 0 ; i < 8 ; i++)
		{
			if (buffer[i] == 0x20)	
			{
				buffer[i] = '.';
				break;
			}
		}
		if (i < 7)
		for (k = i+1 ; k < 8 ; k++)
		{
			buffer[k] = 0x20;
		} 
		printf ("This PIC program is licensed to %c%c%c%c%c%c%c%c%c\n",buffer[0],buffer[1],buffer[2],buffer[3],buffer[4],buffer[5],buffer[6],buffer[7],buffer[8]);
	}
	      	ret = usb_control_msg(udev, 0xC0, GET_SERIAL_NO, 0, 0, buffer, 8, 100);
	if (ret == 8)
	{
		buffer[8] = 0x20;
		for (i = 7 ; i > 0 ; i--)
		{
			if (buffer[i] != 0x20)	
			{
				buffer[i+1] = '.';
				break;
			}
		}
		printf ("Serial Number :  %c%c%c%c%c%c%c%c%c\n",buffer[0],buffer[1],buffer[2],buffer[3],buffer[4],buffer[5],buffer[6],buffer[7],buffer[8]);
	}
	return;
}

void	Inet_SetUp()
{
        if (WSAStartup(2, &wsaData))
        {   printf("winsock initialize failed\n");
            abort();
        }

	recv_sock = socket(AF_INET, SOCK_DGRAM, 0);
        if (recv_sock == INVALID_SOCKET)
        {   printf("did not create sock\n");
            abort();
        }

	send_sock = socket(AF_INET, SOCK_DGRAM, 0);
        if (send_sock == INVALID_SOCKET)
        {   printf("did not create sock\n");
            abort();
        }

	memset(&addr_out, 0, sizeof(addr_out));
	addr_out.sin_family = AF_INET;
	addr_out.sin_port = htons(out_port);

	memset(&addr_in, 0, sizeof(addr_in));
	addr_in.sin_family = AF_INET;
	addr_in.sin_port = htons(in_port);
	addr_in.sin_addr.s_addr = htonl(INADDR_ANY);

	bind(recv_sock, (struct sockaddr *)&addr_in, sizeof(addr_in));

	/* server address set */
	if (p_ent == NULL)
	{
		p_ent = gethostbyname(server);
		if (p_ent == NULL)
		{
			printf ("Server Not Found\n");
			return;
		}
	}
	p_in_addr = (struct in_addr *)p_ent->h_addr;
	if (info) printf("Server IP address : %s\n", inet_ntoa(*p_in_addr));

	memset(&addr_db, 0, sizeof(addr_db));
	addr_db.sin_family = AF_INET;
	addr_db.sin_port = htons(out_port);
	host_ip = inet_addr(inet_ntoa(*p_in_addr));
	addr_db.sin_addr.s_addr = host_ip;
	add_self_node_db (addr_db);
	return;
}

int	callsign_check (char CallSign[])	/* MyCallSign field Check */
{
	FILE	*accctl;
	char	buf[256],str[256];
	char	*token, *last;
	u_int	i;
	int	length;

	accctl = NULL;
	if (accessctrl != NULL)
	{
		accctl = fopen (accessctrl,"r");
		if (debug) printf ("\n%.19s *** Debug ACCESS CONTROL file name : %s\n",curtime(), accessctrl);
	}
	if (accctl == NULL)
	{
			printf ("ACCESS CONTROL FILE NOT FOUND : %s\n",accessctrl);
			return 0;
	}
	
     
	while (fgets(buf, 256, accctl))
	{
		strcpy (str,buf);
		if (str[strlen(str)-1] == 0x0a) str[strlen(str)-1] = 0x00;
		token = str;
		for (i = 0 ; i < strlen(str) ; i++)
		{
			*token = toupper (*token);
			token++;
		}
		length = 8;
		for (i = 0 ; i <= 7 ; i++)
		{
			if (str[7-i] == '*')
			{
				length = 7 - i;
				break;
			}		
		}
		if (length == 0) length = 8;

			if (!strncmp (str, "*", 1))
			{
				if (!strncmp(&str[8],"DENY",4))
				{
					if (debug || Notice) printf ("Deny *\n");
					fclose (accctl);
					return 0;
				}
				if (!strncmp(&str[8],"ALLOW",5))
				{
					if (debug || Notice) printf ("Allow *\n");
					fclose (accctl);
					return 1;
				}
			} else if (!strncmp (str, CallSign, length))
			{ 
				if (!strncmp(&str[8],"DENY",4))
				{
					if (debug || Notice) printf ("Deny %0.8s\n",CallSign);
					fclose (accctl);
					return 0;
				}
				if (!strncmp(&str[8],"ALLOW",5))
				{
					if (debug || Notice) printf ("Allow %0.8s\n",CallSign);
					fclose (accctl);
					return 1;
				}
			}
	}
	if (debug) printf ("Deny %0.8s\n",CallSign);
	fclose (accctl);
	return 0;
	
}
