/**
 *  JavaScript utility library for the Simulink Web View
 *
 *  Copyright 1997-2007 The MathWorks, Inc.
 */

/**
 *  Object to help load svg images
 */
function SvgLoader(filename) 
{
    this.filename = filename;
}

/**
 *  Load svg by writing out EMBED or Object tag for the SVG file
 */
SvgLoader.prototype.execute = function() 
{
    if (hasAdobeSVGPlugin()) {
        // IE with ASV does capture wheel mouse and arrow keys!  We will add
        // listeners here to capture these events before they make it to ASV.
        // For other browser, we add listeners in slwebview.js.
        document.onmousewheel = wheel;
    
        document.write('<embed height="100%" width="100%" '
            + 'src="' + this.filename + '" type="image/svg+xml" '
            + 'pluginspage="http://www.adobe.com/svg/viewer/install/">'
            + '</embed>');
    } else if (hasSVGSupport()) {
        document.write('<object height="100%" width="100%" '
            + 'data="' + this.filename + '" type="image/svg+xml">'
            + '</object>');
    } else {
        document.write(gMsgMap["NoSVGSupport"]);
    }
}

/**
 *  Basic SVG support detection.  Will only fail if IE 6&7 with no ASV plugin.
 */
function hasSVGSupport()
{
    var isSupport = true; // assume SVG support
    var userAgent = navigator.userAgent.toLowerCase();
    var isIE = (userAgent.indexOf("msie") != -1);
    var isIE6orIE7 = false;

    if (isIE) {
        var reg = /msie (\d+.\d+)/;
        var regResult = reg.exec(userAgent);

        if (regResult.length > 1) {
            var ieVer = parseFloat(regResult[1]);
            isIE6orIE7 = (ieVer >= 6 && ieVer <= 7);
        }
    }

    if (isIE6orIE7) {
        isSupport = hasAdobeSVGPlugin();
    }
    return isSupport;
}

/**
 * Checks if the Adobe SVG Plugin is installed, via a VBScript
 */
function hasAdobeSVGPlugin()
{
    var userAgent = navigator.userAgent.toLowerCase();
    var isWin = (userAgent.indexOf("win") != -1);

    if (isWin) {
        document.write('<SCRIPT LANGUAGE="VBScript">\n' 
                        + 'on error resume next \n' 
                        + 'isASVinstalled = IsObject(CreateObject("Adobe.SVGCtl"))' 
                        + '</SCRIPT>\n');
        return window.isASVinstalled;
    }
    return false;
}
