/**
 * Main program code for USB host sample.
 *
 * Copyright 2008 Takashi Chikamasa <takashic@cybernet.co.jp>
 * Based on runc by Lawrie Griffiths <lawrie.griffiths@ntlworld.com>
 * and fwflash by David Anderson <david.anderson@calixo.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "error.h"
#include "lowlevel.h"
#include "samba.h"
#include "firmware.h"

#define NXT_HANDLE_ERR(expr, nxt, msg)     \
  do {                                     \
    nxt_error_t nxt__err_temp = (expr);    \
    if (nxt__err_temp)                     \
      return handle_error(nxt, msg, nxt__err_temp);  \
  } while(0)

static int handle_error(nxt_t *nxt, char *msg, nxt_error_t err)
{
  printf("%s: %s\n", msg, nxt_str_error(err));
  if (nxt != NULL)
    /* nxt_close0 should be used for LEJOS OSEK BIOS(uses leJOS I/O driver) */
    nxt_close0(nxt);
  exit(err);
}

int main(int argc, char *argv[])
{
  nxt_t *nxt;
  nxt_error_t err;

  int ch;
  
  printf("#========================================================#\n");
  printf("#                 Simple USB host sample                 #\n");
  printf("#                                                        #\n");
  printf("# - Run usbtest program in the NXT before starting this  #\n");
  printf("#   program.                                             #\n");
  printf("# - Type characters and press Enter in the keyboard,     #\n");
  printf("#   NXT returns the same characters and displayed        #\n");
  printf("#   in the PC console.                                   #\n");
  printf("# - To stop this program, press Ctrl+D (EOF).            #\n");
  printf("#========================================================#\n\n");

  /* init USB */
  NXT_HANDLE_ERR(nxt_init(&nxt), NULL,
                 "Error during library initialization");
  err = nxt_find(nxt);
  if (err)
  {
      if (err == NXT_NOT_PRESENT)
        printf("NXT not found. Is it properly plugged in via USB?\n");
      else
        NXT_HANDLE_ERR(0, NULL, "Error while scanning for NXT");
      exit(1);
  }

  /* start accessing NXT */
  if (nxt_in_reset_mode(nxt))
  {
      printf("NXT found, but running in reset mode.\n");
      exit(2);
  }

  /* nxt_open0 should be used for LEJOS OSEK USB application */
  NXT_HANDLE_ERR(nxt_open0(nxt), NULL, "Error while connecting to NXT");

  /* send 1 character to NXT and display echo data */
  while((ch = getchar()) != EOF)
  {
   	NXT_HANDLE_ERR(nxt_send_buf(nxt, (unsigned char *)&ch, 1), NULL, "Error Sending data");
   	NXT_HANDLE_ERR(nxt_recv_buf(nxt, (unsigned char *)&ch, 1), NULL, "Error Receiving data");
    putchar(ch);
  }
  
  /* nxt_close0 should be used for LEJOS OSEK application */
  NXT_HANDLE_ERR(nxt_close0(nxt), NULL,
                 "Error while closing connection to NXT");
  return 0;
}
