/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by  Advanced Data Controls, Corp
 *  Copyright (C) 2006 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.3 2006/06/18 09:14:24 roi Exp $
 */

/*
 *  CPU¸ޥ⥸塼At91sam7sѡ
 *  TIMER1(24Mhz)
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <at91sam7s.h>

/*
 *  ޳ߤγֹ
 */
#define INHNO_TIMER    IRQ_TC0_PID

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UW    CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *  TIMER_CLOCK ϥåȥܡ
 */
#define TO_CLOCK(nume, deno) (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)       ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK    ((CLOCK) 0xffffffff)
/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define GET_TOLERANCE    100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
    CLOCK    cyc = TO_CLOCK(TIC_NUME, TIC_DENO);

    /*
     *  ޴Ϣ
     */
	/* å֥͡ */
    sil_wrw_mem((VP)(TADR_PMC_BASE+TOFF_PMC_PCER), (1<<IRQ_TC0_PID));
    /*  */
    sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_CCR), TC_CLKDIS);
    sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_IDR), 0xFFFFFFFF);
    /* ޾ͤΥå */
    assert(cyc <= MAX_CLOCK);
    /* ͤ򥻥å */
	sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_CMR), TC_CLKS_MCK8);	/* 47,923,200Hz/8=5,990,400Hz */
	sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_CMR), sil_rew_mem((VP)(TADR_TC_BASE+TOFF_TC_CMR)) | TC_WAVESEL10);
    sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_RC), cyc);
    /* ߤΥꥢ  */
    sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_IER), TC_CPCS);
    /* ȥ   */
    sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_CCR), (TC_CLKEN|TC_SWTRG));
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
    sil_rew_mem((VP)(TADR_TC_BASE+TOFF_TC_SR));
}

/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate()
{
    /* ڥǥ󥰥ӥåȤ򥯥ꥢ */
	sil_rew_mem((VP)(TADR_TC_BASE+TOFF_TC_SR));
	sil_wrw_mem((VP)(TADR_AIC_BASE+TOFF_AIC_EOICR), 0);
    /*  */
	sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_CCR), TC_CLKDIS);
    /* Ե*/
    sil_wrw_mem((VP)(TADR_TC_BASE+TOFF_TC_IDR), TC_CPCS);
}

/*
 *  ޤθͤɤߤ
 *
 *  ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
    return(TO_CLOCK(TIC_NUME, TIC_DENO) - sil_rew_mem((VP)TADR_TC_BASE+TOFF_TC_CV));
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
    return(sil_rew_mem((VP)(TADR_AIC_BASE+TOFF_AIC_IPR)) & (1<<IRQ_TC0_PID));
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */



