/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.27 2007/01/05 01:02:31 honda Exp $
 */

/*
 *    ץå¸⥸塼 ֥ARMv4ѡ
 */
#define _MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"
#include <armv4.h>
#include <t_config.h>
        
/*
 *  ǥѥå
 *
 *  dispatchϡ
 *  dispatch ϡƥ⡼ɡ߶ػ߾֤ǸƤӽФʤФʤ
 *  _exit_and_dispatch ⡤ƥ⡼ɡ߶ػ߾֤ǸƤӽФ
 *  Τ§Ǥ뤬ͥ뵯ưб뤿ᡤIRQ⡼ɤǸƤӽФ
 *    ˤбƤ롥
 */

        .text
        .align 4    
        .globl dispatch
        .globl exit_and_dispatch
dispatch:
        stmfd sp!, {r4 - r11,lr}   /* 쥸¸ */
        ldr   r0, =runtsk          /* runtskɤ߹ */
        ldr   r1, [r0]
        str   sp, [r1,#TCB_sp]      /* å¸ */
        adr   r2, dispatch_r
        str   r2, [r1,#TCB_pc]      /* ¹ԺƳϤ¸ */
        ldr   r6, =interrupt_count  /* r6 <-interrupt_count */
        mov   r5, #(CPSR_SVC|CPSR_IRQ_BIT)  /* ߶ػ(ƥ⡼) */
        mov   r4, #(CPSR_SVC)               /* ߵ(ƥ⡼) */
        b     dispatcher_1

dispatch_r:
        ldmfd sp!,{r4 - r11,lr}
        /*
         * 㳰롼εư
         * dispatch_r  dispatcher_1 ƤӽФ뤿ᡤ
         * tcbΥɥ쥹r1äƤ
         */
        ldrb  r0,[r1,#TCB_enatex]
        tst   r0,#TCB_enatex_mask
        beq   dispatch_r_1          /* enatex  FALSE ʤ꥿ */
        ldr   r0,[r1,#TCB_texptn]   /* texptn               */
        tst   r0,r0                 /* texptn 0̵         */
        bne   call_texrtn           /* 㳰롼θƤӽФ */
dispatch_r_1:   
#if 0
        mov   pc,lr        
#else /* patch */
	bx lr
#endif



exit_and_dispatch:
        ldr   r6, =interrupt_count /* interrupt_count0ꥢ */
        mov   r3, #0        
        str   r3, [r6]                                        
        /*
         *  FIQϾ˶ػߤ롥
         */
        mov   r5, #(CPSR_SVC|CPSR_IRQ_BIT) /* ߶ػ(ƥ⡼) */
        mov   r4, #(CPSR_SVC)              /* ߵ(ƥ⡼) */
        mrs   r0, cpsr                     /* FIQѾ            */
        and   r0, r0, #CPSR_FIQ_BIT
        orr   r0, r0, r5
        msr   cpsr, r0          /* ƥ⡼ */
dispatcher_1:
        /*
         *  Ǥϥƥ⡼ɡ߶ػ߾֤ǤʤФʤʤ
         */
        ldr   r0, =schedtsk   /* schedtsk ɤ߹ */
        ldr   r1, [r0]
        ldr   r2, =runtsk     /* schedtsk  runtsk */
        str   r1, [r2]        /* schedtsk ʤruntskNULL */
        cmp   r1, #0
        beq   dispatcher_2        
dispatcher_3:           
        ldr   sp, [r1,#TCB_sp] /* å */
        ldr   pc, [r1,#TCB_pc] /* ¹ԺƳϤ   */
dispatcher_2:
        mov   r3,#1
        str   r3, [r6]         /* interupt_count = 1 */
#if 0
        ldr   sp, =STACKTOP
#else /* patch */
        ldr   sp, =(nontask_stack + NONTASK_STACK_SIZE)
#endif
        /* sleep⡼ɤCPUʤ񤭴 */
        mrs   r0, cpsr        /* FIQѾ           */
        and   r0, r0, #CPSR_FIQ_BIT
        orr   r0, r0, r4
        msr   cpsr, r0        /* Ԥ          */
        WAIT_INTERRUPT
        mrs   r0, cpsr        /* FIQѾ           */
        and   r0, r0, #CPSR_FIQ_BIT
        orr   r0, r0, r5
        msr   cpsr, r0        /* ߶ػ          */        
        mov   r3,#0
        str   r3, [r6]        /* interrupt_count = 0 */   
        b     dispatcher_1


                
/*
 *  ư
 */
        .text
        .globl activate_r
activate_r:
        mov   r1,#(CPSR_SVC|CPSR_FIQ_BIT) /* ߵ(ƥ⡼) */
        mrs   r2, cpsr         /* FIQѾ   */
        and   r2, r2, #CPSR_FIQ_BIT
        orr   r1, r1, r2            
        msr   cpsr, r1         /* ߵ */
        ldr   lr, =ext_tsk     /*  */
#if 0
        ldmfd sp!, {r0,pc}     /* ,PC  */
#else /* patch */
        ldmfd sp!, {r0,r1}     /* ,PC  */
	bx r1
#endif


        
/*
 *  ߥϥɥ顿CPU㳰ϥɥи
 *
 *  ret_int ϥƥ⡼ɡIRQ߶ػ߾֤ǸƤӽФ
 */
        .text
        .globl ret_int
        .globl ret_exc 
ret_int:
ret_exc:                
        /*
         *   ƥ⡼ɤ뤳
         */
        ldr   r2, =runtsk       /* runtsk ɤ߹ */
        ldr   r1, [r2]
        ldr   r2, =enadsp
        ldr   r0, [r2]
        cmp   r0, #0
        beq   ret_int_1
        ldr   r2, =schedtsk
        ldr   r0, [r2]
        cmp   r0, r1            /* schedtsk  runtsk  */
        beq   ret_int_1
        stmfd sp!, {r4-r11}     /* ĤΥ쥸¸ */
        str   sp, [r1,#TCB_sp]  /* å¸ */
        adr   r0, ret_int_r     /* ¹ԺƳϤ¸   */
        str   r0, [r1,#TCB_pc]
        b     dispatcher_1

        .global	_kernel_break_wait
_kernel_break_wait:
ret_int_r:
        ldmfd sp!, {r4-r11}     /* 쥸 */
ret_int_1:
        /*
         * 㳰롼εư
         * dispatch_r  dispatcher_1 ƤӽФ뤿ᡤ
         * tcbΥɥ쥹r1äƤ
         * ret_int_1  ret_exe ƤӽФ
         */
        ldrb  r0, [r1,#TCB_enatex]
        tst   r0, #TCB_enatex_mask
        beq   ret_int_2              /* enatex  FALSE ʤ꥿ */
        ldr   r0, [r1,#TCB_texptn]   /* texptn               */
        tst   r0, r0                 /* texptn 0̵         */
        blne  call_texrtn            /* 㳰롼θƤӽФ */        
ret_int_2:              
        ldmfd sp!, {r0}       /* spsr  */
        mrs   r2, cpsr        /* FIQѾ            */
        and   r2, r2, #CPSR_FIQ_BIT
        and   r0, r0, #~CPSR_FIQ_BIT
        orr   r0, r0, r2              
        msr     spsr, r0              /* cpsrspsr */
        ldmfd   sp!,{r0-r3,ip,lr,pc}^ /*  ^դʤΤǡcpsr <- spsr */
        
        /*
         *  Ԥ
         */
	.globl sil_dly_nse
sil_dly_nse:
        sub   r0, r0, #SIL_DLY_TIM1
        cmp   r0, #0
        bgt   _sil_dly_nse1
        movle pc, lr
_sil_dly_nse1:
        sub   r0, r0, #SIL_DLY_TIM2
        cmp   r0, #0
        bgt   _sil_dly_nse1
        movle pc, lr

#if 0
#else /* patch */
	.text
	.align 2
	.global current_sr
current_sr:
	mrs r0, cpsr
	bx lr
	.text
	.align 2
	.global set_sr
set_sr:
	msr cpsr, r0
	bx lr
#endif
