/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	Cxg@\
 */

#include "osek_kernel.h"
#include "check.h"
#include "task.h"
#include "resource.h"

/*
 *  Cxg̃Zbg
 */
StatusType
SetEvent(TaskType tskid, EventMaskType mask)
{
	StatusType	ercd = E_OK;

	LOG_SETEVT_ENTER(tskid, mask);
	CHECK_CALLEVEL(TCL_TASK | TCL_ISR2);
	CHECK_TSKID(tskid);
	CHECK_ACCESS(tskid < tnum_exttask);

	lock_cpu();
	D_CHECK_STATE(tcb_tstat[tskid] != TS_DORMANT);

	tcb_curevt[tskid] |= mask;
	if ((tcb_curevt[tskid] & tcb_waievt[tskid]) != EVTMASK_NONE) {
		tcb_waievt[tskid] = EVTMASK_NONE;
		if ((make_runnable(tskid)) && (callevel == TCL_TASK)) {
			dispatch();
		}
	}
  exit:
	unlock_cpu();
	LOG_SETEVT_LEAVE(ercd);
	return(ercd);

  error_exit:
	lock_cpu();
  d_error_exit:
	_errorhook_par1.tskid = tskid;
	_errorhook_par2.mask = mask;
	call_errorhook(ercd, OSServiceId_SetEvent);
	goto exit;
}

/*
 *  Cxg̃NA
 */
StatusType
ClearEvent(EventMaskType mask)
{
	StatusType	ercd = E_OK;

	LOG_CLREVT_ENTER(mask);
	CHECK_CALLEVEL(TCL_TASK);
	CHECK_ACCESS(runtsk < tnum_exttask);

	lock_cpu();
	tcb_curevt[runtsk] &= ~mask;
  exit:
	unlock_cpu();
	LOG_CLREVT_LEAVE(ercd);
	return(ercd);

  error_exit:
	lock_cpu();
	_errorhook_par1.mask = mask;
	call_errorhook(ercd, OSServiceId_ClearEvent);
	goto exit;
}

/*
 *  Cxg̏ԎQ
 */
StatusType
GetEvent(TaskType tskid, EventMaskRefType p_mask)
{
	StatusType	ercd = E_OK;

	LOG_GETEVT_ENTER(tskid, p_mask);
	CHECK_CALLEVEL(TCL_TASK | TCL_ISR2 | TCL_ERROR | TCL_PREPOST);
	CHECK_TSKID(tskid);
	CHECK_ACCESS(tskid < tnum_exttask);

	lock_cpu();
	D_CHECK_STATE(tcb_tstat[tskid] != TS_DORMANT);
	*p_mask = tcb_curevt[tskid];
  exit:
	unlock_cpu();
	LOG_GETEVT_LEAVE(ercd, *p_mask);
	return(ercd);

  error_exit:
	lock_cpu();
  d_error_exit:
	_errorhook_par1.tskid = tskid;
	_errorhook_par2.p_mask = p_mask;
	call_errorhook(ercd, OSServiceId_GetEvent);
	goto exit;
}

/*
 *  Cxg҂
 */
StatusType
WaitEvent(EventMaskType mask)
{
	StatusType	ercd = E_OK;

	LOG_WAIEVT_ENTER(mask);
	CHECK_CALLEVEL(TCL_TASK);
	CHECK_ACCESS(runtsk < tnum_exttask);
	CHECK_RESOURCE(tcb_lastres[runtsk] == RESID_NULL);

	lock_cpu();
	if ((tcb_curevt[runtsk] & mask) == EVTMASK_NONE) {
		tcb_curpri[runtsk] = tinib_inipri[runtsk];
		tcb_tstat[runtsk] = TS_WAITING;
		tcb_waievt[runtsk] = mask;
		search_schedtsk();
		dispatch();
		tcb_curpri[runtsk] = tinib_exepri[runtsk];
	}
  exit:
	unlock_cpu();
	LOG_WAIEVT_LEAVE(ercd);
	return(ercd);

  error_exit:
	lock_cpu();
	_errorhook_par1.mask = mask;
	call_errorhook(ercd, OSServiceId_WaitEvent);
	goto exit;
}
